/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.recipes;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import mezz.jei.api.ingredients.IIngredientSupplier;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.advanced.IRecipeManagerPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.category.extensions.IRecipeCategoryDecorator;
import mezz.jei.api.recipe.types.IRecipeType;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IIngredientVisibility;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.library.config.RecipeCategorySortingConfig;
import mezz.jei.library.recipes.CraftingStationBuilder;
import mezz.jei.library.recipes.InternalRecipeManagerPlugin;
import mezz.jei.library.recipes.PluginManager;
import mezz.jei.library.recipes.collect.RecipeIngredientRoleMap;
import mezz.jei.library.recipes.collect.RecipeTypeData;
import mezz.jei.library.recipes.collect.RecipeTypeDataMap;
import mezz.jei.library.util.IngredientSupplierHelper;
import mezz.jei.library.util.RecipeDebugUtil;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class RecipeManagerInternal {
    private static final Logger LOGGER = LogManager.getLogger();
    private final @Unmodifiable List<IRecipeCategory<?>> recipeCategories;
    private final IIngredientManager ingredientManager;
    private final RecipeTypeDataMap recipeTypeDataMap;
    private final Comparator<IRecipeCategory<?>> recipeCategoryComparator;
    private final EnumMap<RecipeIngredientRole, RecipeIngredientRoleMap> recipeIngredientRoleMaps;
    private final PluginManager pluginManager;
    private final Set<IRecipeType<?>> hiddenRecipeTypes = new HashSet();
    private final IIngredientVisibility ingredientVisibility;
    private ImmutableListMultimap<IRecipeType<?>, IRecipeCategoryDecorator<?>> recipeCategoryDecorators;
    @Nullable
    private @Unmodifiable List<IRecipeCategory<?>> recipeCategoriesVisibleCache = null;

    public RecipeManagerInternal(List<IRecipeCategory<?>> recipeCategories, ImmutableListMultimap<IRecipeType<?>, ITypedIngredient<?>> recipeCatalysts, IIngredientManager ingredientManager, RecipeCategorySortingConfig recipeCategorySortingConfig, IIngredientVisibility ingredientVisibility) {
        ErrorUtil.checkNotEmpty(recipeCategories, (String)"recipeCategories");
        this.recipeCategoryDecorators = ImmutableListMultimap.of();
        this.ingredientManager = ingredientManager;
        this.ingredientVisibility = ingredientVisibility;
        List<IRecipeType> recipeTypes = recipeCategories.stream().map(IRecipeCategory::getRecipeType).toList();
        Comparator recipeTypeComparator = recipeCategorySortingConfig.getComparator(recipeTypes);
        this.recipeIngredientRoleMaps = new EnumMap(RecipeIngredientRole.class);
        for (RecipeIngredientRole role : RecipeIngredientRole.values()) {
            RecipeIngredientRoleMap recipeIngredientRoleMap = new RecipeIngredientRoleMap(recipeTypeComparator, ingredientManager, role);
            this.recipeIngredientRoleMaps.put(role, recipeIngredientRoleMap);
        }
        this.recipeCategoryComparator = Comparator.comparing(IRecipeCategory::getRecipeType, recipeTypeComparator);
        this.recipeCategories = recipeCategories.stream().sorted(this.recipeCategoryComparator).toList();
        CraftingStationBuilder craftingStationBuilder = new CraftingStationBuilder(this.recipeIngredientRoleMaps.get(RecipeIngredientRole.CRAFTING_STATION));
        for (IRecipeCategory<?> recipeCategory : recipeCategories) {
            IRecipeType recipeType = recipeCategory.getRecipeType();
            if (!recipeCatalysts.containsKey((Object)recipeType)) continue;
            ImmutableList catalysts = recipeCatalysts.get((Object)recipeType);
            craftingStationBuilder.addCategoryCatalysts(recipeCategory, (List<ITypedIngredient<?>>)catalysts);
        }
        ImmutableListMultimap<IRecipeCategory<?>, ITypedIngredient<?>> craftingStationMap = craftingStationBuilder.build();
        this.recipeTypeDataMap = new RecipeTypeDataMap(recipeCategories, craftingStationMap);
        InternalRecipeManagerPlugin internalRecipeManagerPlugin = new InternalRecipeManagerPlugin(ingredientManager, this.recipeTypeDataMap, this.recipeIngredientRoleMaps);
        this.pluginManager = new PluginManager(internalRecipeManagerPlugin);
    }

    public void addPlugins(List<IRecipeManagerPlugin> plugins) {
        this.pluginManager.addAll(plugins);
    }

    public void addDecorators(ImmutableListMultimap<IRecipeType<?>, IRecipeCategoryDecorator<?>> decorators) {
        this.recipeCategoryDecorators = decorators;
    }

    public <T> void addRecipes(IRecipeType<T> recipeType, List<T> recipes) {
        LOGGER.debug("Adding recipes: {}", recipeType);
        RecipeTypeData recipeTypeData = this.recipeTypeDataMap.get(recipeType);
        IRecipeCategory<T> recipeCategory = recipeTypeData.getRecipeCategory();
        Set<T> hiddenRecipes = recipeTypeData.getHiddenRecipes();
        ArrayList<T> addedRecipes = new ArrayList<T>(recipes.size());
        for (T recipe : recipes) {
            if (!this.addRecipe(recipeCategory, recipe, hiddenRecipes)) continue;
            addedRecipes.add(recipe);
        }
        if (!addedRecipes.isEmpty()) {
            recipeTypeData.addRecipes(addedRecipes);
            this.recipeCategoriesVisibleCache = null;
        }
    }

    private <T> boolean addRecipe(IRecipeCategory<T> recipeCategory, T recipe, Set<T> hiddenRecipes) {
        IRecipeType recipeType = recipeCategory.getRecipeType();
        if (hiddenRecipes.contains(recipe)) {
            if (LOGGER.isDebugEnabled()) {
                String recipeInfo = RecipeDebugUtil.getDebugInfoFromRecipe(recipe, recipeCategory, this.ingredientManager);
                LOGGER.debug("Recipe not added because it is hidden: {}", (Object)recipeInfo);
            }
            return false;
        }
        if (!recipeCategory.isHandled(recipe)) {
            if (LOGGER.isDebugEnabled()) {
                String recipeInfo = RecipeDebugUtil.getDebugInfoFromRecipe(recipe, recipeCategory, this.ingredientManager);
                LOGGER.debug("Recipe not added because the recipe category cannot handle it: {}", (Object)recipeInfo);
            }
            return false;
        }
        IIngredientSupplier ingredientSupplier = IngredientSupplierHelper.getIngredientSupplier(recipe, recipeCategory, this.ingredientManager);
        try {
            for (RecipeIngredientRoleMap recipeIngredientRoleMap : this.recipeIngredientRoleMaps.values()) {
                recipeIngredientRoleMap.addRecipe(recipeType, recipe, ingredientSupplier);
            }
            return true;
        }
        catch (LinkageError | RuntimeException e) {
            String recipeInfo = RecipeDebugUtil.getDebugInfoFromRecipe(recipe, recipeCategory, this.ingredientManager);
            LOGGER.error("Found a broken recipe, failed to addRecipe: {}\n", (Object)recipeInfo, (Object)e);
            return false;
        }
    }

    public boolean isCategoryHidden(IRecipeCategory<?> recipeCategory, IFocusGroup focuses) {
        IRecipeType recipeType = recipeCategory.getRecipeType();
        if (this.hiddenRecipeTypes.contains(recipeType)) {
            return true;
        }
        if (this.getCraftingStations(recipeType, true).findAny().isPresent() && this.getCraftingStations(recipeType, false).findAny().isEmpty()) {
            return true;
        }
        Stream visibleRecipes = this.getRecipesStream(recipeType, focuses, false);
        return visibleRecipes.findAny().isEmpty();
    }

    public Stream<IRecipeCategory<?>> getRecipeCategoriesForTypes(Collection<IRecipeType<?>> recipeTypes, IFocusGroup focuses, boolean includeHidden) {
        List<IRecipeCategory<?>> recipeCategories = recipeTypes.stream().map(this.recipeTypeDataMap::get).map(RecipeTypeData::getRecipeCategory).toList();
        return this.getRecipeCategoriesCached(recipeCategories, focuses, includeHidden);
    }

    public <T> IRecipeCategory<T> getRecipeCategory(IRecipeType<T> recipeType) {
        RecipeTypeData<T> value = this.recipeTypeDataMap.get(recipeType);
        return value.getRecipeCategory();
    }

    private Stream<IRecipeCategory<?>> getRecipeCategoriesCached(Collection<IRecipeCategory<?>> recipeCategories, IFocusGroup focuses, boolean includeHidden) {
        if (recipeCategories.isEmpty() && focuses.isEmpty() && !includeHidden) {
            if (this.recipeCategoriesVisibleCache == null) {
                this.recipeCategoriesVisibleCache = this.getRecipeCategoriesUncached(recipeCategories, focuses, false).toList();
            }
            return this.recipeCategoriesVisibleCache.stream();
        }
        return this.getRecipeCategoriesUncached(recipeCategories, focuses, includeHidden);
    }

    private Stream<IRecipeCategory<?>> getRecipeCategoriesUncached(Collection<IRecipeCategory<?>> recipeCategories, IFocusGroup focuses, boolean includeHidden) {
        Stream<Object> categoryStream;
        if (focuses.isEmpty()) {
            categoryStream = recipeCategories.isEmpty() ? this.recipeCategories.stream() : recipeCategories.stream().distinct();
        } else {
            categoryStream = this.pluginManager.getRecipeTypes(focuses).map(this.recipeTypeDataMap::get).map(RecipeTypeData::getRecipeCategory);
            if (!recipeCategories.isEmpty()) {
                categoryStream = categoryStream.filter(recipeCategories::contains);
            }
        }
        if (!includeHidden) {
            categoryStream = categoryStream.filter(c -> !this.isCategoryHidden((IRecipeCategory<?>)c, focuses));
        }
        return categoryStream.sorted(this.recipeCategoryComparator);
    }

    public <T> Stream<T> getRecipesStream(IRecipeType<T> recipeType, IFocusGroup focuses, boolean includeHidden) {
        RecipeTypeData<T> recipeTypeData = this.recipeTypeDataMap.get(recipeType);
        return this.pluginManager.getRecipes(recipeType, recipeTypeData, focuses, includeHidden);
    }

    public <T> Stream<ITypedIngredient<?>> getCraftingStations(IRecipeType<T> recipeType, boolean includeHidden) {
        RecipeTypeData<T> recipeTypeData = this.recipeTypeDataMap.get(recipeType);
        List<ITypedIngredient<?>> craftingStations = recipeTypeData.getCraftingStations();
        if (includeHidden) {
            return craftingStations.stream();
        }
        return craftingStations.stream().filter(arg_0 -> ((IIngredientVisibility)this.ingredientVisibility).isIngredientVisible(arg_0));
    }

    public <T> void hideRecipes(IRecipeType<T> recipeType, Collection<T> recipes) {
        RecipeTypeData<T> recipeTypeData = this.recipeTypeDataMap.get(recipeType);
        Set<T> hiddenRecipes = recipeTypeData.getHiddenRecipes();
        hiddenRecipes.addAll(recipes);
        this.recipeCategoriesVisibleCache = null;
    }

    public <T> void unhideRecipes(IRecipeType<T> recipeType, Collection<T> recipes) {
        RecipeTypeData<T> recipeTypeData = this.recipeTypeDataMap.get(recipeType);
        Set<T> hiddenRecipes = recipeTypeData.getHiddenRecipes();
        hiddenRecipes.removeAll(recipes);
        this.recipeCategoriesVisibleCache = null;
    }

    public void hideRecipeCategory(IRecipeType<?> recipeType) {
        this.hiddenRecipeTypes.add(recipeType);
        this.recipeCategoriesVisibleCache = null;
    }

    public void unhideRecipeCategory(IRecipeType<?> recipeType) {
        this.recipeTypeDataMap.validate(recipeType);
        this.hiddenRecipeTypes.remove(recipeType);
        this.recipeCategoriesVisibleCache = null;
    }

    public <T> Optional<IRecipeType<T>> getRecipeType(ResourceLocation recipeUid, Class<? extends T> recipeClass) {
        return this.recipeTypeDataMap.getType(recipeUid, recipeClass);
    }

    public Optional<IRecipeType<?>> getRecipeType(ResourceLocation recipeUid) {
        return this.recipeTypeDataMap.getType(recipeUid);
    }

    public <T> @Unmodifiable List<IRecipeCategoryDecorator<T>> getRecipeCategoryDecorators(IRecipeType<T> recipeType) {
        ImmutableList decorators = this.recipeCategoryDecorators.get(recipeType);
        return (List)decorators;
    }

    public void compact() {
        this.recipeIngredientRoleMaps.values().forEach(RecipeIngredientRoleMap::compact);
    }

    public boolean isCraftingStation(IRecipeType<?> recipeType, IFocus<?> focus) {
        RecipeIngredientRoleMap recipeIngredientRoleMap = this.recipeIngredientRoleMaps.get(focus.getRole());
        return recipeIngredientRoleMap.isCraftingStationForRecipeCategory(recipeType, focus.getTypedValue());
    }
}

