/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.load.registration;

import com.google.common.collect.ImmutableListMultimap;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.advanced.IRecipeManagerPlugin;
import mezz.jei.api.recipe.advanced.IRecipeManagerPluginHelper;
import mezz.jei.api.recipe.advanced.ISimpleRecipeManagerPlugin;
import mezz.jei.api.recipe.category.extensions.IRecipeCategoryDecorator;
import mezz.jei.api.recipe.types.IRecipeType;
import mezz.jei.api.registration.IAdvancedRegistration;
import mezz.jei.api.runtime.IJeiFeatures;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.core.collect.ListMultiMap;
import mezz.jei.library.load.registration.SingleTypeRecipeManagerPluginAdapter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Unmodifiable;

public class AdvancedRegistration
implements IAdvancedRegistration {
    private static final Logger LOGGER = LogManager.getLogger();
    private final List<IRecipeManagerPlugin> recipeManagerPlugins = new ArrayList<IRecipeManagerPlugin>();
    private final ListMultiMap<IRecipeType<?>, IRecipeCategoryDecorator<?>> recipeCategoryDecorators = new ListMultiMap();
    private final IJeiHelpers jeiHelpers;
    private final IJeiFeatures jeiFeatures;
    private final IRecipeManagerPluginHelper pluginHelper;

    public AdvancedRegistration(IJeiHelpers jeiHelpers, IJeiFeatures jeiFeatures, IRecipeManagerPluginHelper pluginHelper) {
        this.jeiHelpers = jeiHelpers;
        this.jeiFeatures = jeiFeatures;
        this.pluginHelper = pluginHelper;
    }

    public void addRecipeManagerPlugin(IRecipeManagerPlugin recipeManagerPlugin) {
        ErrorUtil.checkNotNull((Object)recipeManagerPlugin, (String)"recipeManagerPlugin");
        LOGGER.info("Added recipe manager plugin: {}", (Object)recipeManagerPlugin.getClass());
        this.recipeManagerPlugins.add(recipeManagerPlugin);
    }

    public <T> void addSimpleRecipeManagerPlugin(IRecipeType<T> recipeType, ISimpleRecipeManagerPlugin<T> recipeManagerPlugin) {
        ErrorUtil.checkNotNull(recipeType, (String)"recipeType");
        ErrorUtil.checkNotNull(recipeManagerPlugin, (String)"recipeManagerPlugin");
        SingleTypeRecipeManagerPluginAdapter<T> adapter = new SingleTypeRecipeManagerPluginAdapter<T>(this.pluginHelper, recipeType, recipeManagerPlugin);
        LOGGER.info("Added typed recipe manager plugin: {}", (Object)recipeManagerPlugin.getClass());
        this.recipeManagerPlugins.add(adapter);
    }

    public <T> void addRecipeCategoryDecorator(IRecipeType<T> recipeType, IRecipeCategoryDecorator<T> decorator) {
        ErrorUtil.checkNotNull(recipeType, (String)"recipeType");
        ErrorUtil.checkNotNull(decorator, (String)"decorator");
        LOGGER.info("Added recipe category decorator: {} for recipe type: {}", (Object)decorator.getClass(), (Object)recipeType.getUid());
        this.recipeCategoryDecorators.put(recipeType, decorator);
    }

    public IJeiHelpers getJeiHelpers() {
        return this.jeiHelpers;
    }

    public IJeiFeatures getJeiFeatures() {
        return this.jeiFeatures;
    }

    public IRecipeManagerPluginHelper getRecipeManagerPluginHelper() {
        return this.pluginHelper;
    }

    public @Unmodifiable List<IRecipeManagerPlugin> getRecipeManagerPlugins() {
        return List.copyOf(this.recipeManagerPlugins);
    }

    public @Unmodifiable ImmutableListMultimap<IRecipeType<?>, IRecipeCategoryDecorator<?>> getRecipeCategoryDecorators() {
        return this.recipeCategoryDecorators.toImmutable();
    }
}

