/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.vanilla.crafting;

import java.util.List;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICraftingCategoryExtension;
import mezz.jei.library.plugins.vanilla.crafting.JeiShapedRecipe;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.ShapedCraftingRecipeDisplay;
import net.minecraft.world.item.crafting.display.ShapelessCraftingRecipeDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplay;

public class CraftingCategoryExtension
implements ICraftingCategoryExtension<CraftingRecipe> {
    public int getWidth(RecipeHolder<CraftingRecipe> recipeHolder) {
        CraftingRecipe recipe = (CraftingRecipe)recipeHolder.value();
        if (recipe instanceof ShapedRecipe) {
            ShapedRecipe shapedRecipe = (ShapedRecipe)recipe;
            return shapedRecipe.getWidth();
        }
        if (recipe instanceof JeiShapedRecipe) {
            JeiShapedRecipe shapedRecipe = (JeiShapedRecipe)recipe;
            return shapedRecipe.getWidth();
        }
        return 0;
    }

    public int getHeight(RecipeHolder<CraftingRecipe> recipeHolder) {
        CraftingRecipe recipe = (CraftingRecipe)recipeHolder.value();
        if (recipe instanceof ShapedRecipe) {
            ShapedRecipe shapedRecipe = (ShapedRecipe)recipe;
            return shapedRecipe.getHeight();
        }
        if (recipe instanceof JeiShapedRecipe) {
            JeiShapedRecipe shapedRecipe = (JeiShapedRecipe)recipe;
            return shapedRecipe.getHeight();
        }
        return 0;
    }

    public boolean isHandled(RecipeHolder<CraftingRecipe> recipeHolder) {
        CraftingRecipe recipe = (CraftingRecipe)recipeHolder.value();
        if (recipe.isSpecial()) {
            return false;
        }
        List displays = recipe.display();
        if (displays.isEmpty()) {
            return false;
        }
        RecipeDisplay display = (RecipeDisplay)displays.getFirst();
        return display instanceof ShapelessCraftingRecipeDisplay || display instanceof ShapedCraftingRecipeDisplay;
    }

    public List<SlotDisplay> getIngredients(RecipeHolder<CraftingRecipe> recipeHolder) {
        List displays = ((CraftingRecipe)recipeHolder.value()).display();
        if (displays.isEmpty()) {
            return List.of();
        }
        RecipeDisplay display = (RecipeDisplay)displays.getFirst();
        if (display instanceof ShapedCraftingRecipeDisplay) {
            ShapedCraftingRecipeDisplay shapedCraftingRecipeDisplay = (ShapedCraftingRecipeDisplay)display;
            return shapedCraftingRecipeDisplay.ingredients();
        }
        if (display instanceof ShapelessCraftingRecipeDisplay) {
            ShapelessCraftingRecipeDisplay shapelessCraftingRecipeDisplay = (ShapelessCraftingRecipeDisplay)display;
            return shapelessCraftingRecipeDisplay.ingredients();
        }
        return List.of();
    }
}

