/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.vanilla.cooking;

import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.library.plugins.vanilla.cooking.AbstractCookingCategory;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.display.FurnaceRecipeDisplay;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.level.block.Blocks;

public class CampfireCookingCategory
extends AbstractCookingCategory<CampfireCookingRecipe> {
    public CampfireCookingCategory(IGuiHelper guiHelper) {
        super(guiHelper, RecipeTypes.CAMPFIRE_COOKING, Blocks.CAMPFIRE, "gui.jei.category.campfire", 400, 82, 44);
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<CampfireCookingRecipe> recipeHolder, IFocusGroup focuses) {
        CampfireCookingRecipe recipe = (CampfireCookingRecipe)recipeHolder.value();
        RecipeDisplay display = (RecipeDisplay)recipe.display().getFirst();
        if (display instanceof FurnaceRecipeDisplay) {
            FurnaceRecipeDisplay furnaceRecipeDisplay = (FurnaceRecipeDisplay)display;
            builder.addInputSlot(1, 1).setStandardSlotBackground().add(furnaceRecipeDisplay.ingredient());
            builder.addOutputSlot(61, 9).setOutputSlotBackground().add(furnaceRecipeDisplay.result());
        }
    }

    @Override
    public void createRecipeExtras(IRecipeExtrasBuilder builder, RecipeHolder<CampfireCookingRecipe> recipeHolder, IFocusGroup focuses) {
        CampfireCookingRecipe recipe = (CampfireCookingRecipe)recipeHolder.value();
        RecipeDisplay display = (RecipeDisplay)recipe.display().getFirst();
        if (display instanceof FurnaceRecipeDisplay) {
            FurnaceRecipeDisplay furnaceRecipeDisplay = (FurnaceRecipeDisplay)display;
            int cookTime = furnaceRecipeDisplay.duration();
            if (cookTime <= 0) {
                cookTime = this.regularCookTime;
            }
            builder.addAnimatedRecipeArrow(cookTime).setPosition(26, 7);
            builder.addAnimatedRecipeFlame(300).setPosition(1, 20);
            this.addCookTime(builder, furnaceRecipeDisplay);
        }
    }
}

