/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.input.handlers;

import java.util.Optional;
import mezz.jei.api.gui.handlers.IGuiProperties;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.config.GiveMode;
import mezz.jei.common.config.IClientConfig;
import mezz.jei.common.config.IClientToggleState;
import mezz.jei.common.gui.JeiTooltip;
import mezz.jei.common.input.IInternalKeyMappings;
import mezz.jei.common.network.IConnectionToServer;
import mezz.jei.common.network.packets.PacketDeletePlayerItem;
import mezz.jei.common.network.packets.PlayToServerPacket;
import mezz.jei.common.util.ServerCommandUtil;
import mezz.jei.gui.input.IUserInputHandler;
import mezz.jei.gui.input.UserInput;
import mezz.jei.gui.overlay.IIngredientGrid;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.ItemStack;

public class DeleteItemInputHandler
implements IUserInputHandler {
    private final IIngredientGrid ingredientGrid;
    private final IClientToggleState toggleState;
    private final IClientConfig clientConfig;
    private final IConnectionToServer serverConnection;
    private final IIngredientManager ingredientManager;

    public DeleteItemInputHandler(IIngredientGrid ingredientGrid, IClientToggleState toggleState, IClientConfig clientConfig, IConnectionToServer serverConnection, IIngredientManager ingredientManager) {
        this.ingredientGrid = ingredientGrid;
        this.toggleState = toggleState;
        this.clientConfig = clientConfig;
        this.serverConnection = serverConnection;
        this.ingredientManager = ingredientManager;
    }

    @Override
    public Optional<IUserInputHandler> handleUserInput(Screen screen, IGuiProperties guiProperties, UserInput userInput, IInternalKeyMappings keyBindings) {
        double mouseY;
        if (!userInput.is(keyBindings.getLeftClick())) {
            return Optional.empty();
        }
        double mouseX = userInput.getMouseX();
        if (!this.ingredientGrid.isMouseOver(mouseX, mouseY = userInput.getMouseY())) {
            return Optional.empty();
        }
        Minecraft minecraft = Minecraft.getInstance();
        if (!this.shouldDeleteItemOnClick(minecraft, mouseX, mouseY)) {
            return Optional.empty();
        }
        LocalPlayer player = minecraft.player;
        if (player == null) {
            return Optional.empty();
        }
        ItemStack itemStack = player.containerMenu.getCarried();
        if (itemStack.isEmpty()) {
            return Optional.empty();
        }
        if (!userInput.isSimulate()) {
            player.containerMenu.setCarried(ItemStack.EMPTY);
            if (!(player.containerMenu instanceof CreativeModeInventoryScreen.ItemPickerMenu)) {
                PacketDeletePlayerItem packet = new PacketDeletePlayerItem(itemStack);
                this.serverConnection.sendPacketToServer((PlayToServerPacket)packet);
            }
        }
        return Optional.of(this);
    }

    public void drawTooltips(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        JeiTooltip tooltip = new JeiTooltip();
        tooltip.add((FormattedText)Component.translatable((String)"jei.tooltip.delete.item"));
        tooltip.draw(guiGraphics, mouseX, mouseY);
    }

    public boolean shouldDeleteItemOnClick(Minecraft minecraft, double mouseX, double mouseY) {
        if (!this.toggleState.isCheatItemsEnabled() || !this.serverConnection.isJeiOnServer()) {
            return false;
        }
        LocalPlayer player = minecraft.player;
        if (player == null) {
            return false;
        }
        ItemStack itemStack = player.containerMenu.getCarried();
        if (itemStack.isEmpty()) {
            return false;
        }
        GiveMode giveMode = this.clientConfig.getGiveMode();
        if (giveMode == GiveMode.MOUSE_PICKUP) {
            return this.ingredientGrid.getIngredientUnderMouse(mouseX, mouseY).findFirst().map(c -> c.getCheatItemStack(this.ingredientManager)).map(i -> !ServerCommandUtil.canStack((ItemStack)itemStack, (ItemStack)i)).orElse(true);
        }
        return true;
    }
}

