/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.bookmarks;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import java.util.List;
import mezz.jei.api.helpers.ICodecHelper;
import mezz.jei.api.ingredients.IIngredientSupplier;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.gui.bookmarks.IBookmark;
import mezz.jei.gui.bookmarks.IngredientBookmark;
import mezz.jei.gui.bookmarks.RecipeBookmark;
import net.minecraft.resources.ResourceLocation;

public enum BookmarkType {
    INGREDIENT{

        public MapCodec<? extends IngredientBookmark<?>> getCodec(ICodecHelper codecHelper, IIngredientManager ingredientManager, IRecipeManager recipeManager) {
            return codecHelper.getTypedIngredientCodec().xmap(i -> IngredientBookmark.create(i, ingredientManager), IngredientBookmark::getIngredient);
        }
    }
    ,
    RECIPE{

        private static <R> Codec<? extends RecipeBookmark<R, ?>> getCodec(IRecipeCategory<R> recipeCategory, ICodecHelper codecHelper, IRecipeManager recipeManager, IIngredientManager ingredientManager) {
            return recipeCategory.getCodec(codecHelper, recipeManager).flatXmap(recipe -> {
                boolean displayIsOutput;
                ITypedIngredient displayIngredient;
                ResourceLocation recipeUid = recipeCategory.getRegistryName(recipe);
                if (recipeUid == null) {
                    return DataResult.error(() -> "Recipe has no registry name");
                }
                IIngredientSupplier ingredients = recipeManager.getRecipeIngredients(recipeCategory, recipe);
                List outputs = ingredients.getIngredients(RecipeIngredientRole.OUTPUT);
                if (!outputs.isEmpty()) {
                    displayIngredient = (ITypedIngredient)outputs.getFirst();
                    displayIsOutput = true;
                } else {
                    List inputs = ingredients.getIngredients(RecipeIngredientRole.INPUT);
                    if (inputs.isEmpty()) {
                        return DataResult.error(() -> "Recipe has no inputs or outputs");
                    }
                    displayIngredient = (ITypedIngredient)inputs.getFirst();
                    displayIsOutput = false;
                }
                displayIngredient = ingredientManager.normalizeTypedIngredient(displayIngredient);
                RecipeBookmark bookmark = new RecipeBookmark(recipeCategory, recipe, recipeUid, displayIngredient, displayIsOutput);
                return DataResult.success(bookmark);
            }, bookmark -> {
                Object recipe = bookmark.getRecipe();
                return DataResult.success(recipe);
            });
        }

        public MapCodec<? extends RecipeBookmark<?, ?>> getCodec(ICodecHelper codecHelper, IIngredientManager ingredientManager, IRecipeManager recipeManager) {
            return codecHelper.getRecipeTypeCodec(recipeManager).dispatchMap("recipeType", bookmark -> bookmark.getRecipeCategory().getRecipeType(), recipeType -> {
                IRecipeCategory recipeCategory = recipeManager.getRecipeCategory(recipeType);
                return 2.getCodec(recipeCategory, codecHelper, recipeManager, ingredientManager).fieldOf("recipe");
            });
        }
    };


    public abstract MapCodec<? extends IBookmark> getCodec(ICodecHelper var1, IIngredientManager var2, IRecipeManager var3);
}

