/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.input.handlers;

import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import mezz.jei.api.gui.handlers.IGuiProperties;
import mezz.jei.common.input.IInternalKeyMappings;
import mezz.jei.gui.input.IUserInputHandler;
import mezz.jei.gui.input.InputType;
import mezz.jei.gui.input.UserInput;
import net.minecraft.client.gui.screens.Screen;

public class CombinedInputHandler
implements IUserInputHandler {
    private final String debugName;
    private final List<IUserInputHandler> inputHandlers;

    public CombinedInputHandler(String debugName, IUserInputHandler ... inputHandlers) {
        this.debugName = debugName;
        this.inputHandlers = List.of(inputHandlers);
    }

    public CombinedInputHandler(String debugName, List<IUserInputHandler> inputHandlers) {
        this.debugName = debugName;
        this.inputHandlers = List.copyOf(inputHandlers);
    }

    @Override
    public Optional<IUserInputHandler> handleUserInput(Screen screen, IGuiProperties guiProperties, UserInput input, IInternalKeyMappings keyBindings) {
        return switch (input.getInputType()) {
            default -> throw new MatchException(null, null);
            case InputType.IMMEDIATE, InputType.SIMULATE -> this.handleClickInternal(screen, guiProperties, input, keyBindings);
            case InputType.EXECUTE -> Optional.empty();
        };
    }

    private Optional<IUserInputHandler> handleClickInternal(Screen screen, IGuiProperties guiProperties, UserInput input, IInternalKeyMappings keyBindings) {
        Optional<IUserInputHandler> firstHandled = Optional.empty();
        for (IUserInputHandler inputHandler : this.inputHandlers) {
            if (firstHandled.isEmpty()) {
                firstHandled = inputHandler.handleUserInput(screen, guiProperties, input, keyBindings);
                if (!firstHandled.isEmpty()) continue;
                inputHandler.unfocus();
                continue;
            }
            inputHandler.unfocus();
        }
        return firstHandled;
    }

    @Override
    public void unfocus() {
        for (IUserInputHandler inputHandler : this.inputHandlers) {
            inputHandler.unfocus();
        }
    }

    @Override
    public Optional<IUserInputHandler> handleMouseScrolled(double mouseX, double mouseY, double scrollDeltaX, double scrollDeltaY) {
        return this.inputHandlers.stream().flatMap(inputHandler -> inputHandler.handleMouseScrolled(mouseX, mouseY, scrollDeltaX, scrollDeltaY).stream()).findFirst();
    }

    public String toString() {
        String inputHandlersString = this.inputHandlers.stream().map((Function<IUserInputHandler, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lmezz/jei/gui/input/IUserInputHandler;)Ljava/lang/String;)()).collect(Collectors.joining(", ", "[", "]"));
        return "CombinedInputHandler{name=" + this.debugName + " inputHandlers=" + inputHandlersString + "}";
    }
}

