package mezz.jei.gui.input;

import com.google.common.base.MoreObjects;
import com.mojang.datafixers.util.Either;
import mezz.jei.common.input.KeyNameUtil;
import mezz.jei.common.input.MouseButtonEventData;
import net.minecraft.class_11908;
import net.minecraft.class_3544;
import net.minecraft.class_3675;

public class KeyUserInput extends UserInput {
	private final class_3675.class_306 key;
	private final class_11908 event;
	private final double mouseX;
	private final double mouseY;
	private final InputType inputType;

	public KeyUserInput(class_11908 event, InputType inputType) {
		this.key = class_3675.method_15985(event);
		this.event = event;
		this.mouseX = MouseUtil.getX();
		this.mouseY = MouseUtil.getY();
		this.inputType = inputType;
	}

	@Override
	public class_3675.class_306 getKey() {
		return key;
	}

	@Override
	public double getMouseX() {
		return mouseX;
	}

	@Override
	public double getMouseY() {
		return mouseY;
	}

	@Override
	public InputType getInputType() {
		return inputType;
	}

	@Override
	public int getModifiers() {
		return event.comp_4797();
	}

	@Override
	public boolean isSimulate() {
		return inputType == InputType.SIMULATE;
	}

	@Override
	public boolean isAllowedChatCharacter() {
		return class_3544.method_57175((char) this.key.method_1444());
	}

	@Override
	public Either<MouseButtonEventData, class_11908> getEvent() {
		return Either.right(event);
	}

	@Override
	public String toString() {
		return MoreObjects.toStringHelper(this)
			.add("inputType", inputType)
			.add("key", KeyNameUtil.getKeyDisplayName(key).getString())
			.add("event", event)
			.add("mouse", String.format("%s, %s", mouseX, mouseY))
			.toString();
	}
}
