/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.vanilla.cooking;

import com.mojang.serialization.Codec;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.placement.HorizontalAlignment;
import mezz.jei.api.gui.placement.VerticalAlignment;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.gui.widgets.ITextWidget;
import mezz.jei.api.helpers.ICodecHelper;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.AbstractRecipeCategory;
import mezz.jei.api.recipe.types.IRecipeHolderType;
import net.minecraft.class_10294;
import net.minecraft.class_10295;
import net.minecraft.class_1874;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_8786;

public abstract class AbstractCookingCategory<T extends class_1874>
extends AbstractRecipeCategory<class_8786<T>> {
    protected final int regularCookTime;

    public AbstractCookingCategory(IGuiHelper guiHelper, IRecipeHolderType<T> recipeType, class_2248 icon, String translationKey, int regularCookTime) {
        this(guiHelper, recipeType, icon, translationKey, regularCookTime, 82, 54);
    }

    public AbstractCookingCategory(IGuiHelper guiHelper, IRecipeHolderType<T> recipeType, class_2248 icon, String translationKey, int regularCookTime, int width, int height) {
        super(recipeType, (class_2561)class_2561.method_43471((String)translationKey), guiHelper.createDrawableItemLike((class_1935)icon), width, height);
        this.regularCookTime = regularCookTime;
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, class_8786<T> recipeHolder, IFocusGroup focuses) {
        class_1874 recipe = (class_1874)recipeHolder.comp_1933();
        class_10295 display = (class_10295)recipe.method_64664().getFirst();
        if (display instanceof class_10294) {
            class_10294 furnaceRecipeDisplay = (class_10294)display;
            builder.addInputSlot(1, 1).setStandardSlotBackground().add(furnaceRecipeDisplay.comp_3256());
            builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 1, 37).setStandardSlotBackground().add(furnaceRecipeDisplay.comp_3257());
            builder.addOutputSlot(61, 19).setOutputSlotBackground().add(furnaceRecipeDisplay.comp_3258());
        }
    }

    @Override
    public void createRecipeExtras(IRecipeExtrasBuilder builder, class_8786<T> recipeHolder, IFocusGroup focuses) {
        class_1874 recipe = (class_1874)recipeHolder.comp_1933();
        class_10295 display = (class_10295)recipe.method_64664().getFirst();
        if (display instanceof class_10294) {
            class_10294 furnaceRecipeDisplay = (class_10294)display;
            int cookTime = furnaceRecipeDisplay.comp_3295();
            if (cookTime <= 0) {
                cookTime = this.regularCookTime;
            }
            builder.addAnimatedRecipeArrow(cookTime).setPosition(26, 17);
            builder.addAnimatedRecipeFlame(300).setPosition(1, 20);
            this.addExperience(builder, furnaceRecipeDisplay);
            this.addCookTime(builder, furnaceRecipeDisplay);
        }
    }

    protected void addExperience(IRecipeExtrasBuilder builder, class_10294 recipe) {
        float experience = recipe.comp_3296();
        if (experience > 0.0f) {
            class_5250 experienceString = class_2561.method_43469((String)"gui.jei.category.smelting.experience", (Object[])new Object[]{Float.valueOf(experience)});
            ((ITextWidget)builder.addText((class_5348)experienceString, this.getWidth() - 20, 10).setPosition(0, 0, this.getWidth(), this.getHeight(), HorizontalAlignment.RIGHT, VerticalAlignment.TOP)).setTextAlignment(HorizontalAlignment.RIGHT).setColor(-8355712);
        }
    }

    protected void addCookTime(IRecipeExtrasBuilder builder, class_10294 recipe) {
        int cookTime = recipe.comp_3295();
        if (cookTime <= 0) {
            cookTime = this.regularCookTime;
        }
        if (cookTime > 0) {
            int cookTimeSeconds = cookTime / 20;
            class_5250 timeString = class_2561.method_43469((String)"gui.jei.category.smelting.time.seconds", (Object[])new Object[]{cookTimeSeconds});
            ((ITextWidget)builder.addText((class_5348)timeString, this.getWidth() - 20, 10).setPosition(0, 0, this.getWidth(), this.getHeight(), HorizontalAlignment.RIGHT, VerticalAlignment.BOTTOM)).setTextAlignment(HorizontalAlignment.RIGHT).setTextAlignment(VerticalAlignment.BOTTOM).setColor(-8355712);
        }
    }

    @Override
    public final Codec<class_8786<T>> getCodec(ICodecHelper codecHelper, IRecipeManager recipeManager) {
        return codecHelper.getRecipeHolderCodec();
    }
}

