package mezz.jei.library.plugins.vanilla.gui;

import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.common.Internal;
import mezz.jei.common.platform.IPlatformRenderHelper;
import mezz.jei.common.platform.IPlatformScreenHelper;
import mezz.jei.common.platform.Services;
import net.minecraft.class_1293;
import net.minecraft.class_310;
import net.minecraft.class_465;
import net.minecraft.class_746;
import net.minecraft.class_768;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class InventoryEffectRendererGuiHandler implements IGuiContainerHandler<class_465<?>> {
	/**
	 * Modeled after {@link DisplayEffectsScreen#drawActivePotionEffects()}
	 */
	@SuppressWarnings("JavadocReference")
	@Override
	public List<class_768> getGuiExtraAreas(class_465<?> containerScreen) {
		if (!Internal.getJeiFeatures().getInventoryEffectRendererGuiHandlerEnabled()) {
			return List.of();
		}
		if (!containerScreen.method_64507()) {
			return List.of();
		}
		class_310 minecraft = class_310.method_1551();
		class_746 player = minecraft.field_1724;
		if (player == null) {
			return Collections.emptyList();
		}
		Collection<class_1293> activePotionEffects = player.method_6026();
		if (activePotionEffects.isEmpty()) {
			return Collections.emptyList();
		}

		IPlatformScreenHelper screenHelper = Services.PLATFORM.getScreenHelper();
		List<class_768> areas = new ArrayList<>();
		int x = screenHelper.getGuiLeft(containerScreen) + screenHelper.getXSize(containerScreen) + 2;
		int y = screenHelper.getGuiTop(containerScreen);
		// JEI always forces the potion effect renderer to "compact" width mode when JEI is open.
		int width = 32;

		int height = 33;
		if (activePotionEffects.size() > 5) {
			height = 132 / (activePotionEffects.size() - 1);
		}
		IPlatformRenderHelper renderHelper = Services.PLATFORM.getRenderHelper();
		for (class_1293 potionEffect : activePotionEffects) {
			if (renderHelper.shouldRender(potionEffect)) {
				areas.add(new class_768(x, y, width, height));
				y += height;
			}
		}
		return areas;
	}
}
