package mezz.jei.fabric.input;

import mezz.jei.common.input.keys.JeiKeyConflictContext;
import net.minecraft.class_3675;

public class FabricJeiKeyMapping extends AbstractJeiKeyMapping {
	protected final FabricKeyMapping fabricMapping;

	public FabricJeiKeyMapping(FabricKeyMapping fabricMapping, JeiKeyConflictContext context) {
		super(context);
		this.fabricMapping = fabricMapping;
	}

	@Override
	protected FabricKeyMapping getMapping() {
		return this.fabricMapping;
	}

	@Override
	public boolean isActiveAndMatches(class_3675.class_306 key) {
		if (isUnbound()) {
			return false;
		}
		if (!this.fabricMapping.realKey.equals(key)) {
			return false;
		}
		return context.isActive();
	}
}
