/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.util;

import java.util.List;
import java.util.Objects;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IStackHelper;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.ingredients.subtypes.ISubtypeManager;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.common.util.ErrorUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class StackHelper
implements IStackHelper {
    private final ISubtypeManager subtypeManager;

    public StackHelper(ISubtypeManager subtypeManager) {
        this.subtypeManager = subtypeManager;
    }

    public boolean isEquivalent(@Nullable ItemStack lhs, @Nullable ItemStack rhs, UidContext context) {
        ErrorUtil.checkNotNull(context, "context");
        if (lhs == rhs) {
            return true;
        }
        if (lhs == null || rhs == null) {
            return false;
        }
        if (lhs.getItem() != rhs.getItem()) {
            return false;
        }
        Object keyLhs = this.subtypeManager.getSubtypeData(lhs, context);
        Object keyRhs = this.subtypeManager.getSubtypeData(rhs, context);
        return Objects.equals(keyLhs, keyRhs);
    }

    public Object getUidForStack(ItemStack stack, UidContext context) {
        Item item = stack.getItem();
        Object subtypeData = this.subtypeManager.getSubtypeData(stack, context);
        if (subtypeData != null) {
            return List.of(item, subtypeData);
        }
        return item;
    }

    public Object getUidForStack(ITypedIngredient<ItemStack> typedIngredient, UidContext context) {
        Item item = (Item)typedIngredient.getBaseIngredient(VanillaTypes.ITEM_STACK);
        Object subtypeData = this.subtypeManager.getSubtypeData(VanillaTypes.ITEM_STACK, typedIngredient, context);
        if (subtypeData != null) {
            return List.of(item, subtypeData);
        }
        return item;
    }

    public boolean hasSubtypes(ItemStack stack) {
        return this.subtypeManager.hasSubtypes(stack);
    }
}

