/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common;

import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.Set;
import mezz.jei.api.runtime.IJeiRuntime;
import mezz.jei.common.Constants;
import mezz.jei.common.JeiFeatures;
import mezz.jei.common.config.ClientToggleState;
import mezz.jei.common.config.IClientToggleState;
import mezz.jei.common.config.IJeiClientConfigs;
import mezz.jei.common.gui.textures.JeiAtlasManager;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.input.IInternalKeyMappings;
import mezz.jei.common.network.IConnectionToServer;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.core.util.Pair;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.client.resources.metadata.gui.GuiMetadataSection;
import net.minecraft.network.Connection;
import net.minecraft.world.item.crafting.RecipeMap;
import org.jetbrains.annotations.Nullable;

public final class Internal {
    @Nullable
    private static Textures textures;
    @Nullable
    private static IConnectionToServer serverConnection;
    @Nullable
    private static IInternalKeyMappings keyMappings;
    @Nullable
    private static IClientToggleState toggleState;
    @Nullable
    private static IJeiClientConfigs jeiClientConfigs;
    @Nullable
    private static IJeiRuntime jeiRuntime;
    @Nullable
    private static Pair<RecipeMap, String> clientSyncedRecipes;
    private static final JeiFeatures jeiFeatures;

    private Internal() {
    }

    public static Textures getTextures() {
        if (textures == null) {
            Minecraft minecraft = Minecraft.getInstance();
            TextureManager textureManager = minecraft.getTextureManager();
            JeiAtlasManager jeiAtlasManager = new JeiAtlasManager(textureManager, new JeiAtlasManager.Config(Constants.LOCATION_JEI_GUI_TEXTURE_ATLAS, Constants.JEI_GUI_TEXTURE_ATLAS_ID, Set.of(AnimationMetadataSection.TYPE, GuiMetadataSection.TYPE)));
            textures = new Textures(jeiAtlasManager);
        }
        return textures;
    }

    public static IConnectionToServer getServerConnection() {
        Preconditions.checkState((serverConnection != null ? 1 : 0) != 0, (Object)"Server Connection has not been created yet.");
        return serverConnection;
    }

    public static void setServerConnection(IConnectionToServer serverConnection) {
        Internal.serverConnection = serverConnection;
    }

    public static IInternalKeyMappings getKeyMappings() {
        Preconditions.checkState((keyMappings != null ? 1 : 0) != 0, (Object)"Key Mappings have not been created yet.");
        return keyMappings;
    }

    public static void setKeyMappings(IInternalKeyMappings keyMappings) {
        Internal.keyMappings = keyMappings;
    }

    public static IClientToggleState getClientToggleState() {
        if (toggleState == null) {
            toggleState = new ClientToggleState();
        }
        return toggleState;
    }

    public static IJeiClientConfigs getJeiClientConfigs() {
        Preconditions.checkState((jeiClientConfigs != null ? 1 : 0) != 0, (Object)"Jei Client Configs have not been created yet.");
        return jeiClientConfigs;
    }

    public static Optional<IJeiClientConfigs> getOptionalJeiClientConfigs() {
        return Optional.ofNullable(jeiClientConfigs);
    }

    public static void setJeiClientConfigs(IJeiClientConfigs jeiClientConfigs) {
        Internal.jeiClientConfigs = jeiClientConfigs;
    }

    public static JeiFeatures getJeiFeatures() {
        return jeiFeatures;
    }

    public static void setRuntime(IJeiRuntime jeiRuntime) {
        Internal.jeiRuntime = jeiRuntime;
    }

    public static IJeiRuntime getJeiRuntime() {
        Preconditions.checkState((jeiRuntime != null ? 1 : 0) != 0, (Object)"Jei Client Configs have not been created yet.");
        return jeiRuntime;
    }

    @Nullable
    private static String getRemoteConnectionId() {
        Connection connection;
        ClientPacketListener clientPacketListener = Minecraft.getInstance().getConnection();
        if (clientPacketListener != null && (connection = clientPacketListener.getConnection()).isConnected()) {
            return connection.getLoggableAddress(true);
        }
        return null;
    }

    public static void setClientSyncedRecipes(RecipeMap clientSyncedRecipes) {
        String connectionId = Internal.getRemoteConnectionId();
        ErrorUtil.checkNotNull(connectionId, "connectionId");
        Internal.clientSyncedRecipes = new Pair((Object)clientSyncedRecipes, (Object)connectionId);
    }

    public static RecipeMap getClientSyncedRecipes() {
        if (clientSyncedRecipes != null) {
            String connectionId = Internal.getRemoteConnectionId();
            if (((String)clientSyncedRecipes.second()).equals(connectionId)) {
                return (RecipeMap)clientSyncedRecipes.first();
            }
        }
        return RecipeMap.EMPTY;
    }

    public static void onRuntimeStopped() {
        if (clientSyncedRecipes != null) {
            String connectionId = Internal.getRemoteConnectionId();
            if (!((String)clientSyncedRecipes.second()).equals(connectionId)) {
                clientSyncedRecipes = null;
            }
        }
        if (jeiClientConfigs != null) {
            jeiClientConfigs.onRuntimeStopped();
        }
        if (toggleState != null) {
            toggleState.clearListeners();
        }
        if (jeiRuntime != null) {
            jeiRuntime = null;
        }
    }

    static {
        clientSyncedRecipes = null;
        jeiFeatures = new JeiFeatures();
    }
}

