/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.vanilla.crafting;

import java.util.List;
import java.util.Optional;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.ingredient.ICraftingGridHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICraftingCategoryExtension;
import mezz.jei.library.plugins.vanilla.crafting.JeiShapedRecipe;
import mezz.jei.library.util.RecipeUtil;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.ShapedRecipe;

public class CraftingCategoryExtension
implements ICraftingCategoryExtension<CraftingRecipe> {
    public void setRecipe(RecipeHolder<CraftingRecipe> recipeHolder, IRecipeLayoutBuilder builder, ICraftingGridHelper craftingGridHelper, IFocusGroup focuses) {
        CraftingRecipe recipe = (CraftingRecipe)recipeHolder.value();
        ItemStack resultItem = RecipeUtil.getResultItem(recipe);
        int width = this.getWidth(recipeHolder);
        int height = this.getHeight(recipeHolder);
        craftingGridHelper.createAndSetOutputs(builder, List.of(resultItem));
        craftingGridHelper.createAndSetIngredients(builder, (List)recipe.getIngredients(), width, height);
    }

    public Optional<ResourceLocation> getRegistryName(RecipeHolder<CraftingRecipe> recipeHolder) {
        return Optional.of(recipeHolder.id());
    }

    public int getWidth(RecipeHolder<CraftingRecipe> recipeHolder) {
        CraftingRecipe recipe = (CraftingRecipe)recipeHolder.value();
        if (recipe instanceof ShapedRecipe) {
            ShapedRecipe shapedRecipe = (ShapedRecipe)recipe;
            return shapedRecipe.getWidth();
        }
        if (recipe instanceof JeiShapedRecipe) {
            JeiShapedRecipe shapedRecipe = (JeiShapedRecipe)recipe;
            return shapedRecipe.getWidth();
        }
        return 0;
    }

    public int getHeight(RecipeHolder<CraftingRecipe> recipeHolder) {
        CraftingRecipe recipe = (CraftingRecipe)recipeHolder.value();
        if (recipe instanceof ShapedRecipe) {
            ShapedRecipe shapedRecipe = (ShapedRecipe)recipe;
            return shapedRecipe.getHeight();
        }
        if (recipe instanceof JeiShapedRecipe) {
            JeiShapedRecipe shapedRecipe = (JeiShapedRecipe)recipe;
            return shapedRecipe.getHeight();
        }
        return 0;
    }

    public boolean isHandled(RecipeHolder<CraftingRecipe> recipeHolder) {
        CraftingRecipe recipe = (CraftingRecipe)recipeHolder.value();
        return !recipe.isSpecial();
    }
}

