/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.ingredients;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.gui.builder.IIngredientAcceptor;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.IIngredientTypeWithSubtypes;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.platform.IPlatformFluidHelperInternal;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.library.ingredients.TypedIngredient;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

public class SimpleIngredientAcceptor
implements IIngredientAcceptor<SimpleIngredientAcceptor> {
    private final IIngredientManager ingredientManager;
    private final List<ITypedIngredient<?>> ingredients = new ArrayList();

    public SimpleIngredientAcceptor(IIngredientManager ingredientManager) {
        this.ingredientManager = ingredientManager;
    }

    public SimpleIngredientAcceptor addIngredientsUnsafe(List<?> ingredients) {
        Preconditions.checkNotNull(ingredients, (Object)"ingredients");
        for (Object ingredient : ingredients) {
            @Nullable ITypedIngredient<?> typedIngredient = TypedIngredient.createAndFilterInvalid(this.ingredientManager, ingredient, false);
            if (typedIngredient == null) continue;
            this.ingredients.add(typedIngredient);
        }
        return this;
    }

    public <T> SimpleIngredientAcceptor addIngredients(IIngredientType<T> ingredientType, List<@Nullable T> ingredients) {
        ErrorUtil.checkNotNull(ingredientType, (String)"ingredientType");
        Preconditions.checkNotNull(ingredients, (Object)"ingredients");
        List<@Nullable ITypedIngredient<T>> typedIngredients = TypedIngredient.createAndFilterInvalidList(this.ingredientManager, ingredientType, ingredients, false);
        for (ITypedIngredient<T> typedIngredientOptional : typedIngredients) {
            if (typedIngredientOptional == null) continue;
            this.ingredients.add(typedIngredientOptional);
        }
        return this;
    }

    public <T> SimpleIngredientAcceptor addIngredient(IIngredientType<T> ingredientType, T ingredient) {
        ErrorUtil.checkNotNull(ingredientType, (String)"ingredientType");
        ErrorUtil.checkNotNull(ingredient, (String)"ingredient");
        this.addIngredientInternal(ingredientType, ingredient);
        return this;
    }

    public <I> SimpleIngredientAcceptor addTypedIngredient(ITypedIngredient<I> typedIngredient) {
        ErrorUtil.checkNotNull(typedIngredient, (String)"typedIngredient");
        @Nullable ITypedIngredient<I> copy = TypedIngredient.defensivelyCopyTypedIngredientFromApi(this.ingredientManager, typedIngredient);
        if (copy != null) {
            this.ingredients.add(copy);
        }
        return this;
    }

    public SimpleIngredientAcceptor addFluidStack(Fluid fluid) {
        IPlatformFluidHelperInternal fluidHelper = Services.PLATFORM.getFluidHelper();
        return this.addFluidInternal(fluidHelper, (Holder<Fluid>)fluid.builtInRegistryHolder(), fluidHelper.bucketVolume(), DataComponentPatch.EMPTY);
    }

    public SimpleIngredientAcceptor addFluidStack(Fluid fluid, long amount) {
        IPlatformFluidHelperInternal fluidHelper = Services.PLATFORM.getFluidHelper();
        return this.addFluidInternal(fluidHelper, (Holder<Fluid>)fluid.builtInRegistryHolder(), amount, DataComponentPatch.EMPTY);
    }

    public SimpleIngredientAcceptor addFluidStack(Fluid fluid, long amount, DataComponentPatch component) {
        IPlatformFluidHelperInternal fluidHelper = Services.PLATFORM.getFluidHelper();
        return this.addFluidInternal(fluidHelper, (Holder<Fluid>)fluid.builtInRegistryHolder(), amount, component);
    }

    private <T> SimpleIngredientAcceptor addFluidInternal(IPlatformFluidHelperInternal<T> fluidHelper, Holder<Fluid> fluidHolder, long amount, DataComponentPatch component) {
        Object fluidStack = fluidHelper.create(fluidHolder, amount, component);
        IIngredientTypeWithSubtypes fluidIngredientType = fluidHelper.getFluidIngredientType();
        this.addIngredientInternal((IIngredientType<T>)fluidIngredientType, (T)fluidStack);
        return this;
    }

    public SimpleIngredientAcceptor addTypedIngredients(List<ITypedIngredient<?>> ingredients) {
        ErrorUtil.checkNotNull(ingredients, (String)"ingredients");
        for (ITypedIngredient<?> typedIngredient : ingredients) {
            this.addTypedIngredient((ITypedIngredient)typedIngredient);
        }
        return this;
    }

    public SimpleIngredientAcceptor addOptionalTypedIngredients(List<Optional<ITypedIngredient<?>>> ingredients) {
        ErrorUtil.checkNotNull(ingredients, (String)"ingredients");
        for (Optional<ITypedIngredient<?>> optionalTypedIngredient : ingredients) {
            if (!optionalTypedIngredient.isPresent()) continue;
            this.ingredients.add(optionalTypedIngredient.get());
        }
        return this;
    }

    private <T> void addIngredientInternal(IIngredientType<T> ingredientType, @Nullable T ingredient) {
        if (ingredient == null) {
            return;
        }
        @Nullable ITypedIngredient<T> typedIngredient = TypedIngredient.createAndFilterInvalid(this.ingredientManager, ingredientType, ingredient, false);
        if (typedIngredient != null) {
            this.ingredients.add(typedIngredient);
        }
    }

    public @UnmodifiableView List<ITypedIngredient<?>> getAllIngredients() {
        return Collections.unmodifiableList(this.ingredients);
    }
}

