/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.vanilla.ingredients.fluid;

import com.google.common.base.MoreObjects;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import mezz.jei.api.constants.Tags;
import mezz.jei.api.helpers.IColorHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientTypeWithSubtypes;
import mezz.jei.api.ingredients.subtypes.ISubtypeManager;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.common.platform.IPlatformFluidHelperInternal;
import mezz.jei.common.util.RegistryUtil;
import mezz.jei.common.util.TagUtil;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;

public class FluidIngredientHelper<T>
implements IIngredientHelper<T> {
    private final ISubtypeManager subtypeManager;
    private final IColorHelper colorHelper;
    private final IPlatformFluidHelperInternal<T> platformFluidHelper;
    private final Registry<Fluid> registry;
    private final IIngredientTypeWithSubtypes<Fluid, T> fluidType;
    private final TagKey<Fluid> hiddenFromRecipeViewers;

    public FluidIngredientHelper(ISubtypeManager subtypeManager, IColorHelper colorHelper, IPlatformFluidHelperInternal<T> platformFluidHelper) {
        this.subtypeManager = subtypeManager;
        this.colorHelper = colorHelper;
        this.platformFluidHelper = platformFluidHelper;
        this.registry = RegistryUtil.getRegistry((ResourceKey)Registries.FLUID);
        this.fluidType = platformFluidHelper.getFluidIngredientType();
        this.hiddenFromRecipeViewers = new TagKey(Registries.FLUID, Tags.HIDDEN_FROM_RECIPE_VIEWERS);
    }

    public IIngredientTypeWithSubtypes<Fluid, T> getIngredientType() {
        return this.fluidType;
    }

    public String getDisplayName(T ingredient) {
        Component displayName = this.platformFluidHelper.getDisplayName(ingredient);
        return displayName.getString();
    }

    public String getUniqueId(T ingredient, UidContext context) {
        Fluid fluid = (Fluid)this.fluidType.getBase(ingredient);
        ResourceLocation registryName = this.getRegistryName(ingredient, fluid);
        StringBuilder result = new StringBuilder().append("fluid:").append(registryName);
        String subtypeInfo = this.subtypeManager.getSubtypeInfo(this.fluidType, ingredient, context);
        if (!subtypeInfo.isEmpty()) {
            result.append(":");
            result.append(subtypeInfo);
        }
        return result.toString();
    }

    public Object getGroupingUid(T ingredient) {
        return this.fluidType.getBase(ingredient);
    }

    public String getWildcardId(T ingredient) {
        Fluid fluid = (Fluid)this.fluidType.getBase(ingredient);
        ResourceLocation registryName = this.getRegistryName(ingredient, fluid);
        return "fluid:" + String.valueOf(registryName);
    }

    public Object getUid(T ingredient, UidContext context) {
        Fluid fluid = (Fluid)this.fluidType.getBase(ingredient);
        Object subtypeData = this.subtypeManager.getSubtypeData(this.fluidType, ingredient, context);
        if (subtypeData != null) {
            return List.of(fluid, subtypeData);
        }
        return fluid;
    }

    public long getAmount(T ingredient) {
        return this.platformFluidHelper.getAmount(ingredient);
    }

    public T copyWithAmount(T ingredient, long amount) {
        return (T)this.platformFluidHelper.copyWithAmount(ingredient, amount);
    }

    public Iterable<Integer> getColors(T ingredient) {
        return this.platformFluidHelper.getStillFluidSprite(ingredient).map(fluidStillSprite -> {
            int renderColor = this.platformFluidHelper.getColorTint(ingredient);
            return this.colorHelper.getColors(fluidStillSprite, renderColor, 1);
        }).orElseGet(List::of);
    }

    public ResourceLocation getResourceLocation(T ingredient) {
        Fluid fluid = (Fluid)this.fluidType.getBase(ingredient);
        return this.getRegistryName(ingredient, fluid);
    }

    private ResourceLocation getRegistryName(T ingredient, Fluid fluid) {
        ResourceLocation key = this.registry.getKey((Object)fluid);
        if (key == null) {
            String ingredientInfo = this.getErrorInfo(ingredient);
            throw new IllegalStateException("null registry name for: " + ingredientInfo);
        }
        return key;
    }

    public ItemStack getCheatItemStack(T ingredient) {
        Fluid fluid = (Fluid)this.fluidType.getBase(ingredient);
        Item filledBucket = fluid.getBucket();
        return filledBucket.getDefaultInstance();
    }

    public T copyIngredient(T ingredient) {
        return (T)this.platformFluidHelper.copy(ingredient);
    }

    public T normalizeIngredient(T ingredient) {
        return (T)this.platformFluidHelper.normalize(ingredient);
    }

    public Stream<ResourceLocation> getTagStream(T ingredient) {
        Fluid fluid = (Fluid)this.fluidType.getBase(ingredient);
        return this.registry.getResourceKey((Object)fluid).flatMap(arg_0 -> this.registry.getHolder(arg_0)).map(Holder::tags).orElse(Stream.of(new TagKey[0])).map(TagKey::location);
    }

    public boolean isHiddenFromRecipeViewersByTags(T ingredient) {
        Fluid fluid = (Fluid)this.fluidType.getBase(ingredient);
        return this.registry.getResourceKey((Object)fluid).flatMap(arg_0 -> this.registry.getHolder(arg_0)).map(holder -> holder.is(this.hiddenFromRecipeViewers)).orElse(false);
    }

    public String getErrorInfo(@Nullable T ingredient) {
        if (ingredient == null) {
            return "null";
        }
        MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper(ingredient.getClass());
        Fluid fluid = (Fluid)this.fluidType.getBase(ingredient);
        if (fluid != null) {
            Component displayName = this.platformFluidHelper.getDisplayName(ingredient);
            toStringHelper.add("Fluid", (Object)displayName.getString());
        } else {
            toStringHelper.add("Fluid", (Object)"null");
        }
        toStringHelper.add("Amount", this.platformFluidHelper.getAmount(ingredient));
        DataComponentPatch components = this.platformFluidHelper.getComponentsPatch(ingredient);
        if (!components.isEmpty()) {
            toStringHelper.add("Components", (Object)components.toString());
        }
        return toStringHelper.toString();
    }

    public Optional<TagKey<?>> getTagKeyEquivalent(Collection<T> ingredients) {
        Registry fluidRegistry = RegistryUtil.getRegistry((ResourceKey)Registries.FLUID);
        return TagUtil.getTagEquivalent(ingredients, arg_0 -> this.fluidType.getBase(arg_0), () -> ((Registry)fluidRegistry).getTags());
    }

    public boolean isIngredientOnServer(T ingredient) {
        Fluid fluid = (Fluid)this.fluidType.getBase(ingredient);
        Registry registry = RegistryUtil.getRegistry((ResourceKey)Registries.FLUID);
        return registry.getKey((Object)fluid) != null;
    }
}

