/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.ingredients;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Stream;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.config.IIngredientFilterConfig;
import mezz.jei.common.util.SafeIngredientUtil;
import mezz.jei.common.util.StringUtil;
import mezz.jei.common.util.Translator;
import mezz.jei.gui.ingredients.DisplayNameUtil;
import mezz.jei.gui.ingredients.IListElement;
import mezz.jei.gui.ingredients.IListElementInfo;
import mezz.jei.gui.ingredients.ListElement;
import mezz.jei.gui.ingredients.ListElementInfoTooltip;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class ListElementInfo<V>
implements IListElementInfo<V> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static int elementCount = 0;
    private final IListElement<V> element;
    private final List<String> names;
    private final List<String> modIds;
    private final List<String> modNames;
    private final ResourceLocation resourceLocation;

    @Nullable
    public static <V> IListElementInfo<V> create(ITypedIngredient<V> value, IIngredientManager ingredientManager, IModIdHelper modIdHelper) {
        int createdIndex = elementCount++;
        ListElement<V> element = new ListElement<V>(value, createdIndex);
        return ListElementInfo.createFromElement(element, ingredientManager, modIdHelper);
    }

    @Nullable
    public static <V> IListElementInfo<V> createFromElement(IListElement<V> element, IIngredientManager ingredientManager, IModIdHelper modIdHelper) {
        try {
            return new ListElementInfo<V>(element, ingredientManager, modIdHelper);
        }
        catch (RuntimeException e) {
            try {
                ITypedIngredient<V> typedIngredient = element.getTypedIngredient();
                IIngredientHelper ingredientHelper = ingredientManager.getIngredientHelper(typedIngredient.getType());
                String ingredientInfo = ingredientHelper.getErrorInfo(typedIngredient.getIngredient());
                LOGGER.warn("Found a broken ingredient {}", (Object)ingredientInfo, (Object)e);
            }
            catch (RuntimeException e2) {
                LOGGER.warn("Found a broken ingredient.", (Throwable)e2);
            }
            return null;
        }
    }

    protected ListElementInfo(IListElement<V> element, IIngredientManager ingredientManager, IModIdHelper modIdHelper) {
        this.element = element;
        ITypedIngredient<V> value = element.getTypedIngredient();
        Object ingredient = value.getIngredient();
        IIngredientHelper ingredientHelper = ingredientManager.getIngredientHelper(value.getType());
        this.resourceLocation = ingredientHelper.getResourceLocation(ingredient);
        String displayModId = ingredientHelper.getDisplayModId(ingredient);
        String modId = this.resourceLocation.getNamespace();
        if (modId.equals(displayModId)) {
            this.modIds = List.of(modId);
            this.modNames = List.of(modIdHelper.getModNameForModId(modId));
        } else {
            this.modIds = List.of(modId, displayModId);
            this.modNames = List.of(modIdHelper.getModNameForModId(modId), modIdHelper.getModNameForModId(displayModId));
        }
        String displayNameLowercase = DisplayNameUtil.getLowercaseDisplayNameForSearch(ingredient, ingredientHelper);
        Collection aliases = ingredientManager.getIngredientAliases(value);
        if (aliases.isEmpty()) {
            this.names = List.of(displayNameLowercase);
        } else {
            this.names = new ArrayList<String>(1 + aliases.size());
            this.names.add(displayNameLowercase);
            for (String alias : aliases) {
                String lowercaseAlias = Translator.toLowercaseWithLocale((String)alias);
                this.names.add(lowercaseAlias);
            }
        }
    }

    @Override
    public List<String> getNames() {
        return this.names;
    }

    @Override
    public String getModNameForSorting() {
        return this.modNames.getFirst();
    }

    @Override
    public List<String> getModNames() {
        return this.modNames;
    }

    @Override
    public List<String> getModIds() {
        return this.modIds;
    }

    @Override
    public final @Unmodifiable Set<String> getTooltipStrings(IIngredientFilterConfig config, IIngredientManager ingredientManager) {
        ITypedIngredient<V> value = this.element.getTypedIngredient();
        IIngredientRenderer ingredientRenderer = ingredientManager.getIngredientRenderer(value.getType());
        TooltipFlag.Default tooltipFlag = config.getSearchAdvancedTooltips() ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL;
        tooltipFlag = tooltipFlag.asCreative();
        ListElementInfoTooltip tooltip = new ListElementInfoTooltip();
        SafeIngredientUtil.getTooltip((ITooltipBuilder)tooltip, (IIngredientManager)ingredientManager, (IIngredientRenderer)ingredientRenderer, value, (TooltipFlag)tooltipFlag);
        Set<String> strings = tooltip.getStrings();
        strings.remove(this.names.getFirst());
        strings.remove(this.modNames.getFirst().toLowerCase(Locale.ENGLISH));
        strings.remove(this.modIds.getFirst());
        strings.remove(this.resourceLocation.getPath());
        return strings;
    }

    @Override
    public Collection<String> getTagStrings(IIngredientManager ingredientManager) {
        ITypedIngredient<V> value = this.element.getTypedIngredient();
        IIngredientHelper ingredientHelper = ingredientManager.getIngredientHelper(value.getType());
        return ingredientHelper.getTagStream(value.getIngredient()).map(ResourceLocation::getPath).toList();
    }

    @Override
    public Stream<ResourceLocation> getTagIds(IIngredientManager ingredientManager) {
        ITypedIngredient<V> value = this.element.getTypedIngredient();
        IIngredientHelper ingredientHelper = ingredientManager.getIngredientHelper(value.getType());
        return ingredientHelper.getTagStream(value.getIngredient());
    }

    @Override
    public Iterable<Integer> getColors(IIngredientManager ingredientManager) {
        ITypedIngredient<V> value = this.element.getTypedIngredient();
        IIngredientHelper ingredientHelper = ingredientManager.getIngredientHelper(value.getType());
        Object ingredient = value.getIngredient();
        return ingredientHelper.getColors(ingredient);
    }

    @Override
    public @Unmodifiable Collection<String> getCreativeTabsStrings(IIngredientManager ingredientManager) {
        ItemStack itemStack = this.element.getTypedIngredient().getItemStack().orElse(ItemStack.EMPTY);
        if (itemStack.isEmpty()) {
            return List.of();
        }
        HashSet<String> creativeTabStrings = new HashSet<String>();
        for (CreativeModeTab itemGroup : CreativeModeTabs.allTabs()) {
            if (!itemGroup.shouldDisplay() || itemGroup.getType() != CreativeModeTab.Type.CATEGORY || !itemGroup.contains(itemStack)) continue;
            String name = itemGroup.getDisplayName().getString();
            name = StringUtil.removeChatFormatting((String)name);
            name = Translator.toLowercaseWithLocale((String)name);
            Collections.addAll(creativeTabStrings, name.split(" "));
        }
        return creativeTabStrings;
    }

    @Override
    public ResourceLocation getResourceLocation() {
        return this.resourceLocation;
    }

    @Override
    public IListElement<V> getElement() {
        return this.element;
    }

    @Override
    public ITypedIngredient<V> getTypedIngredient() {
        return this.element.getTypedIngredient();
    }

    @Override
    public int getCreatedIndex() {
        return this.element.getCreatedIndex();
    }
}

