/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.forge;

import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import mezz.jei.api.IModPlugin;
import mezz.jei.common.Internal;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.network.IConnectionToServer;
import mezz.jei.forge.events.PermanentEventSubscriptions;
import mezz.jei.forge.network.NetworkHandler;
import mezz.jei.forge.plugins.forge.ForgeGuiPlugin;
import mezz.jei.forge.startup.ForgePluginFinder;
import mezz.jei.forge.startup.StartEventObserver;
import mezz.jei.gui.config.InternalKeyMappings;
import mezz.jei.gui.overlay.bookmarks.IngredientsTooltipComponent;
import mezz.jei.gui.overlay.bookmarks.PreviewTooltipComponent;
import mezz.jei.library.gui.ingredients.TagContentTooltipComponent;
import mezz.jei.library.plugins.vanilla.crafting.JeiShapedRecipe;
import mezz.jei.library.recipes.RecipeSerializers;
import mezz.jei.library.startup.JeiStarter;
import mezz.jei.library.startup.StartData;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class JustEnoughItemsClient {
    private final PermanentEventSubscriptions subscriptions;

    public JustEnoughItemsClient(NetworkHandler networkHandler, PermanentEventSubscriptions subscriptions) {
        this.subscriptions = subscriptions;
        IConnectionToServer serverConnection = networkHandler.getConnectionToServer();
        InternalKeyMappings keyMappings = JustEnoughItemsClient.createKeyMappings(subscriptions);
        Internal.setKeyMappings(keyMappings);
        List<IModPlugin> plugins = ForgePluginFinder.getModPlugins();
        StartData startData = new StartData(plugins, serverConnection, keyMappings);
        JeiStarter jeiStarter = new JeiStarter(startData);
        StartEventObserver startEventObserver = new StartEventObserver(jeiStarter::start, jeiStarter::stop);
        startEventObserver.register(subscriptions);
    }

    public void register() {
        this.subscriptions.register(RegisterClientReloadListenersEvent.class, this::onRegisterReloadListenerEvent);
        this.subscriptions.register(RegisterClientTooltipComponentFactoriesEvent.class, this::onRegisterClientTooltipEvent);
        IEventBus modEventBus = this.subscriptions.getModEventBus();
        DeferredRegister deferredRegister = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"jei");
        deferredRegister.register(modEventBus);
        RegistryObject jeiShaped = deferredRegister.register("jei_shaped", JeiShapedRecipe.Serializer::new);
        RecipeSerializers.register(jeiShaped);
    }

    private void onRegisterReloadListenerEvent(RegisterClientReloadListenersEvent event) {
        Textures textures = Internal.getTextures();
        event.registerReloadListener((PreparableReloadListener)textures.getSpriteUploader());
        event.registerReloadListener((PreparableReloadListener)this.createReloadListener());
    }

    private void onRegisterClientTooltipEvent(RegisterClientTooltipComponentFactoriesEvent event) {
        event.register(IngredientsTooltipComponent.class, Function.identity());
        event.register(PreviewTooltipComponent.class, Function.identity());
        event.register(TagContentTooltipComponent.class, Function.identity());
    }

    private ResourceManagerReloadListener createReloadListener() {
        return resourceManager -> ForgeGuiPlugin.getResourceReloadHandler().ifPresent(r -> r.onResourceManagerReload(resourceManager));
    }

    private static InternalKeyMappings createKeyMappings(PermanentEventSubscriptions subscriptions) {
        HashSet keysToRegister = new HashSet();
        subscriptions.register(RegisterKeyMappingsEvent.class, e -> keysToRegister.forEach(arg_0 -> ((RegisterKeyMappingsEvent)e).register(arg_0)));
        return new InternalKeyMappings(keysToRegister::add);
    }
}

