package mezz.jei.library.plugins.vanilla.brewing;

import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.vanilla.IJeiBrewingRecipe;
import mezz.jei.library.plugins.vanilla.ingredients.subtypes.PotionSubtypeInterpreter;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.Objects;

public class JeiBrewingRecipe implements IJeiBrewingRecipe {
	private final List<class_1799> ingredients;
	private final List<class_1799> potionInputs;
	private final class_1799 potionOutput;
	private final @Nullable class_2960 uid;
	private final BrewingRecipeUtil brewingRecipeUtil;
	private final int hashCode;

	public JeiBrewingRecipe(
		List<class_1799> ingredients,
		List<class_1799> potionInputs,
		class_1799 potionOutput,
		@Nullable class_2960 uid,
		BrewingRecipeUtil brewingRecipeUtil
	) {
		this.ingredients = List.copyOf(ingredients);
		this.potionInputs = List.copyOf(potionInputs);
		this.potionOutput = potionOutput;
		this.uid = uid;
		this.brewingRecipeUtil = brewingRecipeUtil;

		brewingRecipeUtil.addRecipe(potionInputs, potionOutput);

		if (uid != null) {
			this.hashCode = uid.hashCode();
		} else {
			this.hashCode = Objects.hash(
				ingredients.stream().map(class_1799::method_7909).toList(),
				potionInputs.stream().map(class_1799::method_7909).toList(),
				potionOutput.method_7909()
			);
		}
	}

	@Override
	public List<class_1799> getPotionInputs() {
		return potionInputs;
	}

	@Override
	public List<class_1799> getIngredients() {
		return ingredients;
	}

	@Override
	public class_1799 getPotionOutput() {
		return potionOutput;
	}

	@Nullable
	@Override
	public class_2960 getUid() {
		return uid;
	}

	@Override
	public boolean equals(Object obj) {
		if (!(obj instanceof JeiBrewingRecipe other)) {
			return false;
		}

		if (uid != null) {
			return uid.equals(other.uid);
		}

		for (int i = 0; i < potionInputs.size(); i++) {
			class_1799 potionInput = potionInputs.get(i);
			class_1799 otherPotionInput = other.potionInputs.get(i);
			if (!arePotionsEqual(potionInput, otherPotionInput)) {
				return false;
			}
		}

		if (!arePotionsEqual(other.potionOutput, potionOutput)) {
			return false;
		}

		if (ingredients.size() != other.ingredients.size()) {
			return false;
		}

		for (int i = 0; i < ingredients.size(); i++) {
			if (!class_1799.method_7973(ingredients.get(i), other.ingredients.get(i))) {
				return false;
			}
		}

		return true;
	}

	private static boolean arePotionsEqual(class_1799 potion1, class_1799 potion2) {
		Object key1 = PotionSubtypeInterpreter.INSTANCE.getSubtypeData(potion1, UidContext.Recipe);
		Object key2 = PotionSubtypeInterpreter.INSTANCE.getSubtypeData(potion2, UidContext.Recipe);
		return Objects.equals(key1, key2);
	}

	@Override
	public int getBrewingSteps() {
		return brewingRecipeUtil.getBrewingSteps(potionOutput);
	}

	@Override
	public int hashCode() {
		return hashCode;
	}

	@Override
	public String toString() {
		class_1799 input = potionInputs.getFirst();
		String inputName = PotionSubtypeInterpreter.INSTANCE.getStringName(input);
		String outputName = PotionSubtypeInterpreter.INSTANCE.getStringName(potionOutput);
		return ingredients + " + [" + input.method_7909() + " " + inputName + "] = [" + potionOutput + " " + outputName + "]";
	}
}
