package mezz.jei.gui.elements;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import mezz.jei.api.gui.buttons.IButtonState;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.common.Internal;
import mezz.jei.common.gui.elements.DrawableBlank;
import mezz.jei.common.gui.elements.DrawableNineSliceTexture;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.util.ImmutableRect2i;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_5244;

/**
 * A button that has an {@link IDrawable} instead of a string label.
 * This internal class is used for re-using vanilla render code and to override behavior.
 * See {@link IconButton} for the class that uses this.
 */
class InternalIconButton extends class_4185 implements IButtonState {
	private IDrawable icon = DrawableBlank.EMPTY;
	private boolean pressed = false;
	private boolean forcePressed = false;

	public InternalIconButton() {
		super(0, 0, 0, 0, class_5244.field_39003, b -> {}, class_4185.field_40754);
	}

	public void updateBounds(ImmutableRect2i area) {
		method_46421(area.getX());
		method_46419(area.getY());
		this.field_22758 = area.getWidth();
		this.field_22759 = area.getHeight();
	}

	@Override
	public void method_53533(int value) {
		this.field_22759 = value;
	}

	@Override
	public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
		RenderSystem.setShaderColor(1.0F, 1.0F, 1.0F, 1.0F);
		boolean hovered =
			mouseX >= this.method_46426() &&
				mouseY >= this.method_46427() &&
				mouseX < this.method_46426() + this.field_22758 &&
				mouseY < this.method_46427() + this.field_22759;
		RenderSystem.enableBlend();
		RenderSystem.blendFuncSeparate(
			GlStateManager.class_4535.SRC_ALPHA,
			GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA,
			GlStateManager.class_4535.ONE,
			GlStateManager.class_4534.ZERO
		);
		RenderSystem.blendFunc(GlStateManager.class_4535.SRC_ALPHA, GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
		Textures textures = Internal.getTextures();
		boolean isPressed = this.pressed || this.forcePressed;
		DrawableNineSliceTexture texture = textures.getButtonForState(isPressed, this.field_22763, hovered);
		texture.draw(guiGraphics, this.method_46426(), this.method_46427(), this.field_22758, this.field_22759);

		int color = 0xFFE0E0E0;
		if (!this.field_22763) {
			color = 0xFFA0A0A0;
		} else if (hovered) {
			color = 0xFFFFFFFF;
		}

		float red = (color >> 16 & 255) / 255.0F;
		float blue = (color >> 8 & 255) / 255.0F;
		float green = (color & 255) / 255.0F;
		float alpha = (color >> 24 & 255) / 255.0F;
		RenderSystem.setShaderColor(red, blue, green, alpha);

		double xOffset = method_46426() + (field_22758 - icon.getWidth()) / 2.0;
		double yOffset = method_46427() + (field_22759 - icon.getHeight()) / 2.0;
		if (isPressed) {
			xOffset += 0.5;
			yOffset += 0.5;
		}
		var poseStack = guiGraphics.method_51448();
		poseStack.method_22903();
		{
			poseStack.method_22904(xOffset, yOffset, 0);
			icon.draw(guiGraphics);
		}
		poseStack.method_22909();
		RenderSystem.setShaderColor(1.0F, 1.0F, 1.0F, 1.0F);
	}


	public void setPressed(boolean pressed) {
		this.pressed = pressed;
	}

	@Override
	public void setForcePressed(boolean forcePressed) {
		this.forcePressed = forcePressed;
	}

	@Override
	public boolean method_25361(double x, double y) {
		return super.method_25361(x, y);
	}

	@Override
	public boolean method_25351(int mouseButton) {
		return super.method_25351(mouseButton);
	}

	@Override
	public void setIcon(IDrawable icon) {
		this.icon = icon;
	}

	@Override
	public void setActive(boolean value) {
		this.field_22763 = value;
	}

	@Override
	public void setVisible(boolean value) {
		this.field_22764 = value;
	}
}
