package mezz.jei.library.plugins.vanilla.grindstone;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import mezz.jei.api.recipe.vanilla.IJeiGrindstoneRecipe;
import mezz.jei.common.util.MathUtil;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_9304;
import net.minecraft.class_9636;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

import java.util.List;

public final class GrindstoneRecipe implements IJeiGrindstoneRecipe {
	private final List<class_1799> topInputs;
	private final List<class_1799> bottomInputs;
	private final List<class_1799> outputs;
	private int minXpReward;
	private final int maxXpReward;
	private final @Nullable class_2960 uid;

	public GrindstoneRecipe(
		List<class_1799> topInputs,
		List<class_1799> bottomInputs,
		List<class_1799> outputs,
		int minXpReward,
		int maxXpReward,
		@Nullable class_2960 uid
	) {
		this.topInputs = topInputs;
		this.bottomInputs = bottomInputs;
		this.outputs = outputs;
		this.minXpReward = minXpReward;
		this.maxXpReward = maxXpReward;
		this.uid = uid;
	}

	@Override
	@Unmodifiable
	public List<class_1799> getTopInputs() {
		return topInputs;
	}

	@Override
	@Unmodifiable
	public List<class_1799> getBottomInputs() {
		return bottomInputs;
	}

	@Override
	@Unmodifiable
	public List<class_1799> getOutputs() {
		return outputs;
	}

	@Override
	public int getMinXpReward() {
		if (minXpReward < 0) {
			minXpReward = getMinXp(topInputs.getFirst(), bottomInputs.getFirst());
		}
		return minXpReward;
	}

	@Override
	public int getMaxXpReward() {
		if (maxXpReward < 0) {
			return getMinXpReward() * 2;
		}
		return maxXpReward;
	}

	@Override
	@Nullable
	public class_2960 getUid() {
		return uid;
	}

	@Override
	@Unmodifiable
	public boolean isOutputRenderOnly() {
		return true;
	}

	private static int getMinXp(class_1799 topItem, class_1799 bottomItem) {
		int topXp = getExperienceFromItem(topItem);
		int bottomXp = getExperienceFromItem(bottomItem);
		return MathUtil.divideCeil(topXp + bottomXp, 2);
	}

	private static int getExperienceFromItem(class_1799 stack) {
		int i = 0;
		class_9304 itemEnchantments = class_1890.method_57532(stack);

		for (Object2IntMap.Entry<class_6880<class_1887>> entry : itemEnchantments.method_57539()) {
			class_6880<class_1887> holder = entry.getKey();
			int j = entry.getIntValue();
			if (!holder.method_40220(class_9636.field_51551)) {
				i += holder.comp_349().method_8182(j);
			}
		}

		return i;
	}
}
