package mezz.jei.library.plugins.vanilla.crafting;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import mezz.jei.library.recipes.RecipeSerializers;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_3955;
import net.minecraft.class_7225;
import net.minecraft.class_7710;
import net.minecraft.class_8957;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9694;
import java.util.List;

public class JeiShapedRecipe implements class_3955 {
	private final class_8957 pattern;
	private final List<class_1799> results;
	private final String group;
	private final class_7710 category;

	public JeiShapedRecipe(String group, class_7710 category, class_8957 pattern, List<class_1799> results) {
		this.group = group;
		this.category = category;
		this.pattern = pattern;
		this.results = results;
	}

	@Override
	public class_1865<?> method_8119() {
		return RecipeSerializers.getJeiShapedRecipeSerializer();
	}

	@Override
	public String method_8112() {
		return this.group;
	}

	@Override
	public class_7710 method_45441() {
		return this.category;
	}

	@Override
	public class_1799 method_8110(class_7225.class_7874 registries) {
		return this.results.getFirst();
	}

	@Override
	public class_2371<class_1856> method_8117() {
		return this.pattern.method_59997();
	}

	@Override
	public boolean method_49188() {
		return false;
	}

	@Override
	public boolean method_8113(int width, int height) {
		return width >= this.pattern.method_59995() && height >= this.pattern.method_59996();
	}

	@Override
	public boolean matches(class_9694 input, class_1937 level) {
		return this.pattern.method_55078(input);
	}

	@Override
	public class_1799 assemble(class_9694 input, class_7225.class_7874 registries) {
		return this.method_8110(registries).method_7972();
	}

	public int getWidth() {
		return this.pattern.method_59995();
	}

	public int getHeight() {
		return this.pattern.method_59996();
	}

	@Override
	public boolean method_31584() {
		class_2371<class_1856> nonNullList = this.method_8117();
		return nonNullList.isEmpty() || nonNullList.stream().filter((ingredient) -> {
			return !ingredient.method_8103();
		}).anyMatch((ingredient) -> {
			return ingredient.method_8105().length == 0;
		});
	}

	public static class Serializer implements class_1865<JeiShapedRecipe> {
		public static final MapCodec<JeiShapedRecipe> CODEC = RecordCodecBuilder.mapCodec((instance) -> {
			return instance.group(Codec.STRING.optionalFieldOf("group", "").forGetter((shapedRecipe) -> {
				return shapedRecipe.group;
			}), class_7710.field_40252.fieldOf("category").orElse(class_7710.field_40251).forGetter((shapedRecipe) -> {
				return shapedRecipe.category;
			}), class_8957.field_47321.forGetter((shapedRecipe) -> {
				return shapedRecipe.pattern;
			}), Codec.list(class_1799.field_51397).fieldOf("result").forGetter((shapedRecipe) -> {
				return shapedRecipe.results;
			})).apply(instance, JeiShapedRecipe::new);
		});
		public static final class_9139<class_9129, JeiShapedRecipe> STREAM_CODEC = class_9139.method_56437(Serializer::toNetwork, Serializer::fromNetwork);

		public Serializer() {
		}

		public MapCodec<JeiShapedRecipe> method_53736() {
			return CODEC;
		}

		public class_9139<class_9129, JeiShapedRecipe> method_56104() {
			return STREAM_CODEC;
		}

		private static JeiShapedRecipe fromNetwork(class_9129 buffer) {
			String string = buffer.method_19772();
			class_7710 craftingBookCategory = buffer.method_10818(class_7710.class);
			class_8957 shapedRecipePattern = class_8957.field_48359.decode(buffer);
			List<class_1799> results = class_1799.field_48350.decode(buffer);
			return new JeiShapedRecipe(string, craftingBookCategory, shapedRecipePattern, results);
		}

		private static void toNetwork(class_9129 buffer, JeiShapedRecipe recipe) {
			buffer.method_10814(recipe.group);
			buffer.method_10817(recipe.category);
			class_8957.field_48359.encode(buffer, recipe.pattern);
			class_1799.field_48350.encode(buffer, recipe.results);
		}
	}
}
