package mezz.jei.gui.overlay;

import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.inputs.IJeiUserInput;
import mezz.jei.common.Internal;
import mezz.jei.common.config.IClientToggleState;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.input.IInternalKeyMappings;
import mezz.jei.common.network.IConnectionToServer;
import mezz.jei.common.network.packets.PacketRequestCheatPermission;
import mezz.jei.common.platform.IPlatformConfigHelper;
import mezz.jei.common.platform.Services;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_437;
import mezz.jei.api.gui.buttons.IButtonState;
import mezz.jei.api.gui.buttons.IIconButtonController;
import java.util.Optional;
import java.util.function.BooleanSupplier;

public class ConfigButtonController implements IIconButtonController {
	private final IDrawable normalIcon;
	private final IDrawable cheatIcon;
	private final BooleanSupplier isListDisplayed;
	private final IClientToggleState toggleState;
	private final IInternalKeyMappings keyBindings;

	public ConfigButtonController(BooleanSupplier isListDisplayed, IClientToggleState toggleState, IInternalKeyMappings keyBindings) {
		Textures textures = Internal.getTextures();
		this.normalIcon = textures.getConfigButtonIcon();
		this.cheatIcon = textures.getConfigButtonCheatIcon();
		this.isListDisplayed = isListDisplayed;
		this.toggleState = toggleState;
		this.keyBindings = keyBindings;
	}

	@Override
	public void updateState(IButtonState state) {
		if (toggleState.isCheatItemsEnabled()) {
			state.setIcon(cheatIcon);
		} else {
			state.setIcon(normalIcon);
		}
	}

	@Override
	public void getTooltips(ITooltipBuilder tooltip) {
		tooltip.add(class_2561.method_43471("jei.tooltip.config"));
		if (!toggleState.isOverlayEnabled()) {
			tooltip.add(
				class_2561.method_43471("jei.tooltip.ingredient.list.disabled")
					.method_27692(class_124.field_1065)
			);
			tooltip.addKeyUsageComponent(
				"jei.tooltip.ingredient.list.disabled.how.to.fix",
				keyBindings.getToggleOverlay()
			);
		} else if (!isListDisplayed.getAsBoolean()) {
			tooltip.add(
				class_2561.method_43471("jei.tooltip.not.enough.space")
					.method_27692(class_124.field_1065)
			);
		}
		if (toggleState.isCheatItemsEnabled()) {
			tooltip.add(
				class_2561.method_43471("jei.tooltip.cheat.mode.button.enabled")
					.method_27692(class_124.field_1061)
			);

			if (!keyBindings.getToggleCheatMode().isUnbound()) {
				tooltip.addKeyUsageComponent(
					"jei.tooltip.cheat.mode.how.to.disable.hotkey",
					keyBindings.getToggleCheatMode()
				);
			} else if (!keyBindings.getToggleCheatModeConfigButton().isUnbound()) {
				tooltip.addKeyUsageComponent(
					"jei.tooltip.cheat.mode.how.to.disable.hover.config.button.hotkey",
					keyBindings.getToggleCheatModeConfigButton()
				);
			}
		}
	}

	@Override
	public boolean onPress(IJeiUserInput input) {
		if (toggleState.isOverlayEnabled()) {
			if (!input.isSimulate()) {
				if (input.is(keyBindings.getToggleCheatModeConfigButton())) {
					toggleState.toggleCheatItemsEnabled();
					if (toggleState.isCheatItemsEnabled()) {
						IConnectionToServer serverConnection = Internal.getServerConnection();
						serverConnection.sendPacketToServer(PacketRequestCheatPermission.INSTANCE);
					}
				} else {
					openSettings();
				}
			}
			return true;
		}
		return false;
	}

	private static void openSettings() {
		class_310 mc = class_310.method_1551();
		if (mc.field_1724 == null) {
			return;
		}

		IPlatformConfigHelper configHelper = Services.PLATFORM.getConfigHelper();
		Optional<class_437> configScreen = configHelper.getConfigScreen();

		if (configScreen.isPresent()) {
			mc.method_1507(configScreen.get());
		} else {
			class_2561 message = getMissingConfigScreenMessage(configHelper);
			mc.field_1724.method_7353(message, false);
		}
	}

	private static class_2561 getMissingConfigScreenMessage(IPlatformConfigHelper configHelper) {
		return class_2561.method_43471("jei.message.configured")
			.method_10862(
				class_2583.field_24360
					.method_10977(class_124.field_1058)
					.method_30938(true)
					.method_10958(
						new class_2558(
							class_2558.class_2559.field_11749,
							"https://www.curseforge.com/minecraft/mc-mods/configured"
						)
					)
			)
			.method_27693("\n")
			.method_10852(
				class_2561.method_43471("jei.message.config.folder")
					.method_10862(
						class_2583.field_24360
							.method_10977(class_124.field_1068)
							.method_30938(true)
							.method_10958(
								new class_2558(
									class_2558.class_2559.field_11746,
									configHelper.createJeiConfigDir().toAbsolutePath().toString()
								)
							)
					)
			);
	}
}
