package mezz.jei.common.network.packets;

import mezz.jei.api.constants.ModIds;
import mezz.jei.common.config.IServerConfig;
import mezz.jei.common.network.IConnectionToClient;
import mezz.jei.common.network.ServerPacketContext;
import mezz.jei.common.util.ServerCommandUtil;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public class PacketRequestCheatPermission extends PlayToServerPacket<PacketRequestCheatPermission> {
	public static final PacketRequestCheatPermission INSTANCE = new PacketRequestCheatPermission();
	public static final class_8710.class_9154<PacketRequestCheatPermission> TYPE = new class_8710.class_9154<>(class_2960.method_60655(ModIds.JEI_ID, "request_cheat_permission"));
	public static final class_9139<class_9129, PacketRequestCheatPermission> STREAM_CODEC = class_9139.method_56431(INSTANCE);

	private PacketRequestCheatPermission() {

	}

	@Override
	public class_9154<PacketRequestCheatPermission> method_56479() {
		return TYPE;
	}

	@Override
	public class_9139<class_9129, PacketRequestCheatPermission> streamCodec() {
		return STREAM_CODEC;
	}

	@Override
	public void process(ServerPacketContext context) {
		class_3222 player = context.player();
		IServerConfig serverConfig = context.serverConfig();
		boolean hasPermission = ServerCommandUtil.hasPermissionForCheatMode(player, serverConfig);
		PacketCheatPermission packetCheatPermission = new PacketCheatPermission(hasPermission, serverConfig);

		IConnectionToClient connection = context.connection();
		connection.sendPacketToClient(packetCheatPermission, player);
	}
}
