package mezz.jei.library.render.batch;

import com.mojang.blaze3d.systems.RenderSystem;
import mezz.jei.api.ingredients.rendering.BatchRenderElement;
import mezz.jei.common.platform.IPlatformRenderHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.library.render.ItemStackRenderer;
import net.minecraft.class_1087;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_148;
import net.minecraft.class_1799;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_638;
import net.minecraft.class_811;
import net.minecraft.class_918;
import java.util.ArrayList;
import java.util.List;

public final class ItemStackBatchRenderer {
	private final List<ElementWithModel> useBlockLight;
	private final List<ElementWithModel> noBlockLight;
	private final List<BatchRenderElement<class_1799>> customRender;

	public ItemStackBatchRenderer(class_310 minecraft, List<BatchRenderElement<class_1799>> elements) {
		this.useBlockLight = new ArrayList<>();
		this.noBlockLight = new ArrayList<>();
		this.customRender = new ArrayList<>();

		class_638 level = minecraft.field_1687;
		class_918 itemRenderer = minecraft.method_1480();

		for (BatchRenderElement<class_1799> element : elements) {
			class_1799 itemStack = element.ingredient();
			if (!itemStack.method_7960()) {
				class_1087 bakedmodel = itemRenderer.method_4019(itemStack, level, null, 0);
				if (bakedmodel.method_4713()) {
					customRender.add(element);
				} else if (bakedmodel.method_24304()) {
					ElementWithModel elementWithModel = new ElementWithModel(bakedmodel, itemStack, element.x(), element.y());
					useBlockLight.add(elementWithModel);
				} else {
					if (!bakedmodel.method_4712()) {
						IPlatformRenderHelper renderHelper = Services.PLATFORM.getRenderHelper();
						bakedmodel = renderHelper.createLimitedQuadItemModel(bakedmodel);
					}
					ElementWithModel elementWithModel = new ElementWithModel(bakedmodel, itemStack, element.x(), element.y());
					noBlockLight.add(elementWithModel);
				}
			}
		}
	}

	public void render(class_332 guiGraphics, class_310 minecraft, class_918 itemRenderer, ItemStackRenderer itemStackRenderer) {
		if (!noBlockLight.isEmpty()) {
			class_308.method_24210();
			for (ElementWithModel element : noBlockLight) {
				renderItem(guiGraphics, itemRenderer, element.model(), element.stack(), element.x(), element.y());
			}
			guiGraphics.method_51452();
			class_308.method_24211();
		}

		if (!useBlockLight.isEmpty()) {
			class_308.method_24211();
			for (ElementWithModel element : useBlockLight) {
				renderItem(guiGraphics, itemRenderer, element.model(), element.stack(), element.x(), element.y());
			}
			guiGraphics.method_51452();
		}

		IPlatformRenderHelper renderHelper = Services.PLATFORM.getRenderHelper();
		for (ElementWithModel element : useBlockLight) {
			class_1799 ingredient = element.stack();
			class_327 font = renderHelper.getFontRenderer(minecraft, ingredient);
			guiGraphics.method_51431(font, ingredient, element.x(), element.y());
		}
		for (ElementWithModel element : noBlockLight) {
			class_1799 ingredient = element.stack();
			class_327 font = renderHelper.getFontRenderer(minecraft, ingredient);
			guiGraphics.method_51431(font, ingredient, element.x(), element.y());
		}
		RenderSystem.disableBlend();
		for (BatchRenderElement<class_1799> element : customRender) {
			class_1799 ingredient = element.ingredient();
			itemStackRenderer.render(guiGraphics, ingredient, element.x(), element.y());
			RenderSystem.disableBlend();
		}
		RenderSystem.disableBlend();
	}

	private void renderItem(
		class_332 guiGraphics,
		class_918 itemRenderer,
		class_1087 bakedmodel,
		class_1799 itemStack,
		int x,
		int y
	) {
		class_4587 poseStack = guiGraphics.method_51448();
		poseStack.method_22903();
		poseStack.method_46416((float) (x + 8), (float) (y + 8), 150f);
		poseStack.method_22905(16.0F, -16.0F, 16.0F);

		try {
			itemRenderer.method_23179(
				itemStack,
				class_811.field_4317,
				false,
				poseStack,
				guiGraphics.method_51450(),
				0xf000f0,
				class_4608.field_21444,
				bakedmodel
			);
		} catch (Throwable throwable) {
			class_128 crashreport = class_128.method_560(throwable, "Rendering item");
			class_129 crashreportcategory = crashreport.method_562("Item being rendered");
			crashreportcategory.method_577("Item Type", () -> String.valueOf(itemStack.method_7909()));
			crashreportcategory.method_577("Item Components", () -> String.valueOf(itemStack.method_57353()));
			crashreportcategory.method_577("Item Foil", () -> String.valueOf(itemStack.method_7958()));
			throw new class_148(crashreport);
		}

		poseStack.method_22909();
	}
}
