package mezz.jei.library.plugins.vanilla.ingredients.subtypes;

import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import net.minecraft.class_1799;
import net.minecraft.class_9283;
import net.minecraft.class_9284;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;

public class FireworkRocketSubtypeInterpreter implements ISubtypeInterpreter<class_1799> {
	public static final FireworkRocketSubtypeInterpreter INSTANCE = new FireworkRocketSubtypeInterpreter();

	private FireworkRocketSubtypeInterpreter() {

	}

	@Override
	public @Nullable Object getSubtypeData(class_1799 ingredient, UidContext context) {
		return ingredient.method_57824(class_9334.field_49616);
	}

	@Override
	public String getLegacyStringSubtypeInfo(class_1799 itemStack, UidContext context) {
		class_9284 fireworks = itemStack.method_57824(class_9334.field_49616);
		if (fireworks == null) {
			return "";
		}
		List<class_9283> explosions = fireworks.comp_2392();
		List<String> strings = new ArrayList<>();
		for (class_9283 e : explosions) {
			class_9283.class_1782 shape = e.comp_2386();
			strings.add(shape.method_15434());
		}

		StringJoiner joiner = new StringJoiner(",", "[", "]");
		strings.sort(null);
		for (String s : strings) {
			joiner.add(s);
		}

		int flightDuration = fireworks.comp_2391();
		return flightDuration + ":" + joiner;
	}
}
