package mezz.jei.gui.overlay.bookmarks;

import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.inputs.IJeiUserInput;
import mezz.jei.api.runtime.IJeiKeyMapping;
import mezz.jei.common.Internal;
import mezz.jei.common.config.IClientToggleState;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.input.IInternalKeyMappings;
import mezz.jei.gui.bookmarks.BookmarkList;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import mezz.jei.api.gui.buttons.IButtonState;
import mezz.jei.api.gui.buttons.IIconButtonController;

public class BookmarkButtonController implements IIconButtonController {
	private final IDrawable offIcon;
	private final IDrawable onIcon;
	private final BookmarkOverlay bookmarkOverlay;
	private final BookmarkList bookmarkList;
	private final IClientToggleState toggleState;
	private final IInternalKeyMappings keyBindings;

	public BookmarkButtonController(BookmarkOverlay bookmarkOverlay, BookmarkList bookmarkList, IClientToggleState toggleState, IInternalKeyMappings keyBindings) {
		Textures textures = Internal.getTextures();
		this.offIcon = textures.getBookmarkButtonDisabledIcon();
		this.onIcon = textures.getBookmarkButtonEnabledIcon();
		this.bookmarkOverlay = bookmarkOverlay;
		this.bookmarkList = bookmarkList;
		this.toggleState = toggleState;
		this.keyBindings = keyBindings;
	}

	@Override
	public void getTooltips(ITooltipBuilder tooltip) {
		if (toggleState.isBookmarkOverlayEnabled()) {
			tooltip.add(class_2561.method_43471("jei.tooltip.bookmarks.disable"));
		} else {
			tooltip.add(class_2561.method_43471("jei.tooltip.bookmarks.enable"));
		}
		IJeiKeyMapping bookmarkKey = keyBindings.getBookmark();
		if (bookmarkKey.isUnbound()) {
			class_5250 noKey = class_2561.method_43471("jei.tooltip.bookmarks.usage.nokey");
			tooltip.add(noKey.method_27692(class_124.field_1061));
		} else if (!bookmarkOverlay.hasRoom()) {
			class_5250 notEnoughSpace = class_2561.method_43471("jei.tooltip.bookmarks.not.enough.space");
			tooltip.add(notEnoughSpace.method_27692(class_124.field_1065));
		} else {
			tooltip.addKeyUsageComponent(
				"jei.tooltip.bookmarks.usage.key",
				bookmarkKey
			);
		}
	}

	@Override
	public void updateState(IButtonState state) {
		if (toggleState.isBookmarkOverlayEnabled()) {
			state.setIcon(onIcon);
			state.setForcePressed(true);
		} else {
			state.setIcon(offIcon);
			state.setForcePressed(false);
		}
	}

	@Override
	public boolean onPress(IJeiUserInput input) {
		if (!bookmarkList.isEmpty() && bookmarkOverlay.hasRoom()) {
			if (!input.isSimulate()) {
				toggleState.toggleBookmarkEnabled();
			}
			return true;
		}
		return false;
	}
}
