package mezz.jei.library.plugins.vanilla.crafting;

import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.util.ErrorUtil;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_310;
import net.minecraft.class_3859;
import net.minecraft.class_3861;
import net.minecraft.class_3862;
import net.minecraft.class_3920;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_3975;
import net.minecraft.class_638;
import net.minecraft.class_8059;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class VanillaRecipes {
	private final class_1863 recipeManager;
	private final IIngredientManager ingredientManager;

	public VanillaRecipes(IIngredientManager ingredientManager) {
		class_310 minecraft = class_310.method_1551();
		ErrorUtil.checkNotNull(minecraft, "minecraft");
		class_638 world = minecraft.field_1687;
		ErrorUtil.checkNotNull(world, "minecraft world");
		this.recipeManager = world.method_8433();
		this.ingredientManager = ingredientManager;
	}

	public Map<Boolean, List<class_8786<class_3955>>> getCraftingRecipes(IRecipeCategory<class_8786<class_3955>> craftingCategory) {
		var validator = new CategoryRecipeValidator<>(craftingCategory, ingredientManager, 9);

		List<class_8786<class_3955>> handled = new ArrayList<>();
		List<class_8786<class_3955>> unhandled = new ArrayList<>();

		List<class_8786<class_3955>> allRecipes = recipeManager.method_30027(class_3956.field_17545);
		for (class_8786<class_3955> recipe : allRecipes) {
			if (validator.isRecipeValid(recipe)) {
				if (validator.isRecipeHandled(recipe)) {
					handled.add(recipe);
				} else {
					unhandled.add(recipe);
				}
			}
		}
		return Map.of(
			true, handled,
			false, unhandled
		);
	}

	public List<class_8786<class_3975>> getStonecuttingRecipes(IRecipeCategory<class_8786<class_3975>> stonecuttingCategory) {
		var validator = new CategoryRecipeValidator<>(stonecuttingCategory, ingredientManager, 1);
		return getValidHandledRecipes(recipeManager, class_3956.field_17641, validator);
	}

	public List<class_8786<class_3861>> getFurnaceRecipes(IRecipeCategory<class_8786<class_3861>> furnaceCategory) {
		CategoryRecipeValidator<class_3861> validator = new CategoryRecipeValidator<>(furnaceCategory, ingredientManager, 1);
		return getValidHandledRecipes(recipeManager, class_3956.field_17546, validator);
	}

	public List<class_8786<class_3862>> getSmokingRecipes(IRecipeCategory<class_8786<class_3862>> smokingCategory) {
		CategoryRecipeValidator<class_3862> validator = new CategoryRecipeValidator<>(smokingCategory, ingredientManager, 1);
		return getValidHandledRecipes(recipeManager, class_3956.field_17548, validator);
	}

	public List<class_8786<class_3859>> getBlastingRecipes(IRecipeCategory<class_8786<class_3859>> blastingCategory) {
		CategoryRecipeValidator<class_3859> validator = new CategoryRecipeValidator<>(blastingCategory, ingredientManager, 1);
		return getValidHandledRecipes(recipeManager, class_3956.field_17547, validator);
	}

	public List<class_8786<class_3920>> getCampfireCookingRecipes(IRecipeCategory<class_8786<class_3920>> campfireCategory) {
		CategoryRecipeValidator<class_3920> validator = new CategoryRecipeValidator<>(campfireCategory, ingredientManager, 1);
		return getValidHandledRecipes(recipeManager, class_3956.field_17549, validator);
	}

	public List<class_8786<class_8059>> getSmithingRecipes(IRecipeCategory<class_8786<class_8059>> smithingCategory) {
		CategoryRecipeValidator<class_8059> validator = new CategoryRecipeValidator<>(smithingCategory, ingredientManager, 0);
		return getValidHandledRecipes(recipeManager, class_3956.field_25388, validator);
	}

	private static <C extends class_9695, T extends class_1860<C>> List<class_8786<T>> getValidHandledRecipes(
		class_1863 recipeManager,
		class_3956<T> recipeType,
		CategoryRecipeValidator<T> validator
	) {
		return recipeManager.method_30027(recipeType)
			.stream()
			.filter(r -> validator.isRecipeValid(r) && validator.isRecipeHandled(r))
			.toList();
	}

}
