package mezz.jei.common.gui;

import mezz.jei.api.gui.inputs.IJeiInputHandler;
import mezz.jei.api.gui.inputs.IJeiUserInput;
import mezz.jei.common.util.MathUtil;
import net.minecraft.class_3675;
import net.minecraft.class_8029;
import net.minecraft.class_8030;
import java.util.function.Supplier;

public class OffsetJeiInputHandler implements IJeiInputHandler {
	private final IJeiInputHandler inputHandler;
	private final Supplier<class_8029> offset;

	public OffsetJeiInputHandler(IJeiInputHandler inputHandler, Supplier<class_8029> offset) {
		this.inputHandler = inputHandler;
		this.offset = offset;
	}

	@Override
	public boolean handleInput(double mouseX, double mouseY, IJeiUserInput input) {
		class_8029 screenPosition = offset.get();
		final double offsetMouseX = mouseX - screenPosition.comp_1193();
		final double offsetMouseY = mouseY - screenPosition.comp_1194();

		class_8030 originalArea = inputHandler.getArea();
		if (MathUtil.contains(originalArea, offsetMouseX, offsetMouseY)) {
			class_8029 position = originalArea.comp_1195();
			double relativeMouseX = offsetMouseX - position.comp_1193();
			double relativeMouseY = offsetMouseY - position.comp_1194();
			return inputHandler.handleInput(relativeMouseX, relativeMouseY, input);
		}

		return false;
	}

	@Override
	public boolean handleMouseScrolled(double mouseX, double mouseY, double scrollDeltaX, double scrollDeltaY) {
		class_8029 screenPosition = offset.get();
		final double offsetMouseX = mouseX - screenPosition.comp_1193();
		final double offsetMouseY = mouseY - screenPosition.comp_1194();

		class_8030 originalArea = inputHandler.getArea();
		if (MathUtil.contains(originalArea, offsetMouseX, offsetMouseY)) {
			class_8029 position = originalArea.comp_1195();
			double relativeMouseX = offsetMouseX - position.comp_1193();
			double relativeMouseY = offsetMouseY - position.comp_1194();
			return inputHandler.handleMouseScrolled(relativeMouseX, relativeMouseY, scrollDeltaX, scrollDeltaY);
		}

		return false;
	}

	@Override
	public boolean handleMouseDragged(double mouseX, double mouseY, class_3675.class_306 mouseKey, double dragX, double dragY) {
		class_8029 screenPosition = offset.get();
		final double offsetMouseX = mouseX - screenPosition.comp_1193();
		final double offsetMouseY = mouseY - screenPosition.comp_1194();

		class_8030 originalArea = inputHandler.getArea();
		if (MathUtil.contains(originalArea, offsetMouseX, offsetMouseY)) {
			class_8029 position = originalArea.comp_1195();
			double relativeMouseX = offsetMouseX - position.comp_1193();
			double relativeMouseY = offsetMouseY - position.comp_1194();
			return inputHandler.handleMouseDragged(relativeMouseX, relativeMouseY, mouseKey, dragX, dragY);
		}

		return false;
	}

	@Override
	public void handleMouseMoved(double mouseX, double mouseY) {
		class_8029 screenPosition = offset.get();
		final double offsetMouseX = mouseX - screenPosition.comp_1193();
		final double offsetMouseY = mouseY - screenPosition.comp_1194();

		class_8030 originalArea = inputHandler.getArea();
		if (MathUtil.contains(originalArea, offsetMouseX, offsetMouseY)) {
			class_8029 position = originalArea.comp_1195();
			double relativeMouseX = offsetMouseX - position.comp_1193();
			double relativeMouseY = offsetMouseY - position.comp_1194();
			inputHandler.handleMouseMoved(relativeMouseX, relativeMouseY);
		}
	}

	@Override
	public class_8030 getArea() {
		class_8030 area = inputHandler.getArea();
		return new class_8030(offset.get(), area.comp_1196(), area.comp_1197());
	}
}
