package mezz.jei.library.plugins.vanilla.crafting;

import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.library.util.RecipeDebugUtil;
import mezz.jei.library.util.RecipeUtil;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_8786;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import java.util.List;

public final class CategoryRecipeValidator<T extends class_1860<?>> {
	private static final Logger LOGGER = LogManager.getLogger();
	private static final int INVALID_COUNT = -1;
	private final IRecipeCategory<class_8786<T>> recipeCategory;
	private final IIngredientManager ingredientManager;
	private final int maxInputs;

	public CategoryRecipeValidator(IRecipeCategory<class_8786<T>> recipeCategory, IIngredientManager ingredientManager, int maxInputs) {
		this.recipeCategory = recipeCategory;
		this.ingredientManager = ingredientManager;
		this.maxInputs = maxInputs;
	}

	public boolean isRecipeValid(class_8786<T> recipeHolder) {
		return hasValidInputsAndOutputs(recipeHolder);
	}

	public boolean isRecipeHandled(class_8786<T> recipeHolder) {
		return this.recipeCategory.isHandled(recipeHolder);
	}

	@SuppressWarnings("ConstantConditions")
	private boolean hasValidInputsAndOutputs(class_8786<T> recipeHolder) {
		T recipe = recipeHolder.comp_1933();
		if (recipe.method_8118()) {
			return true;
		}
		class_1799 recipeOutput = RecipeUtil.getResultItem(recipe);
		if (recipeOutput == null || recipeOutput.method_7960()) {
			if (LOGGER.isDebugEnabled()) {
				String recipeInfo = RecipeDebugUtil.getDebugInfoFromRecipe(recipeHolder, recipeCategory, ingredientManager);
				LOGGER.debug("Skipping Recipe because it has no output. {}", recipeInfo);
			}
			return false;
		}
		List<class_1856> ingredients = recipe.method_8117();
		if (ingredients == null) {
			if (LOGGER.isDebugEnabled()) {
				String recipeInfo = RecipeDebugUtil.getDebugInfoFromRecipe(recipeHolder, recipeCategory, ingredientManager);
				LOGGER.debug("Skipping Recipe because it has no input Ingredients. {}", recipeInfo);
			}
			return false;
		}
		int inputCount = getInputCount(ingredients);
		if (inputCount == INVALID_COUNT) {
			if (LOGGER.isDebugEnabled()) {
				String recipeInfo = RecipeDebugUtil.getDebugInfoFromRecipe(recipeHolder, recipeCategory, ingredientManager);
				LOGGER.debug("Skipping Recipe because it contains invalid inputs. {}", recipeInfo);
			}
			return false;
		} else if (inputCount > maxInputs) {
			if (LOGGER.isDebugEnabled()) {
				String recipeInfo = RecipeDebugUtil.getDebugInfoFromRecipe(recipeHolder, recipeCategory, ingredientManager);
				LOGGER.debug("Skipping Recipe because it has too many inputs. {}", recipeInfo);
			}
			return false;
		} else if (inputCount == 0 && maxInputs > 0) {
			if (LOGGER.isDebugEnabled()) {
				String recipeInfo = RecipeDebugUtil.getDebugInfoFromRecipe(recipeHolder, recipeCategory, ingredientManager);
				LOGGER.debug("Skipping Recipe because it has no inputs. {}", recipeInfo);
			}
			return false;
		}
		return true;
	}

	@SuppressWarnings("ConstantConditions")
	private static int getInputCount(List<class_1856> ingredientList) {
		int inputCount = 0;
		for (class_1856 ingredient : ingredientList) {
			class_1799[] input = ingredient.method_8105();
			if (input == null) {
				return INVALID_COUNT;
			} else {
				inputCount++;
			}
		}
		return inputCount;
	}
}
