package mezz.jei.library.plugins.vanilla.grindstone;

import mezz.jei.api.recipe.vanilla.IJeiGrindstoneRecipe;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

import java.util.List;

public record GrindstoneRecipe(
		List<class_1799> topInputs,
		List<class_1799> bottomInputs,
		List<class_1799> outputs,
		int minXpReward,
		int maxXpReward,
		@Nullable class_2960 uid,
		boolean isOutputRenderOnly
) implements IJeiGrindstoneRecipe {

	public GrindstoneRecipe(
			List<class_1799> topInputs,
			List<class_1799> bottomInputs,
			List<class_1799> outputs,
			int minXpReward,
			int maxXpReward,
			@Nullable class_2960 uid) {
		this(topInputs, bottomInputs, outputs, minXpReward, maxXpReward, uid, true);
	}

	@Override
	@Unmodifiable
	@NotNull
	public List<class_1799> getTopInputs() {
		return topInputs;
	}

	@Override
	@Unmodifiable
	@NotNull
	public List<class_1799> getBottomInputs() {
		return bottomInputs;
	}

	@Override
	@Unmodifiable
	@NotNull
	public List<class_1799> getOutputs() {
		return outputs;
	}

	@Override
	public int getMinXpReward() {
		return minXpReward;
	}

	@Override
	public int getMaxXpReward() {
		return maxXpReward;
	}

	@Override
	@Nullable
	public class_2960 getUid() {
		return uid;
	}

	@Override
	@Unmodifiable
	public boolean isOutputRenderOnly() {
		return isOutputRenderOnly;
	}
}
