package mezz.jei.fabric.platform;

import mezz.jei.common.platform.IPlatformScreenHelper;
import mezz.jei.common.util.ImmutableRect2i;
import net.minecraft.class_1041;
import net.minecraft.class_1735;
import net.minecraft.class_310;
import net.minecraft.class_342;
import net.minecraft.class_368;
import net.minecraft.class_374;
import net.minecraft.class_465;
import net.minecraft.class_507;
import net.minecraft.class_512;
import net.minecraft.class_518;
import java.util.List;
import java.util.Optional;

public class ScreenHelper implements IPlatformScreenHelper {
	@Override
	public Optional<class_1735> getSlotUnderMouse(class_465<?> containerScreen) {
		class_1735 slot = containerScreen.field_2787;
		return Optional.ofNullable(slot);
	}

	@Override
	public int getGuiLeft(class_465<?> containerScreen) {
		return containerScreen.field_2776;
	}

	@Override
	public int getGuiTop(class_465<?> containerScreen) {
		return containerScreen.field_2800;
	}

	@Override
	public int getXSize(class_465<?> containerScreen) {
		return containerScreen.field_2792;
	}

	@Override
	public int getYSize(class_465<?> containerScreen) {
		return containerScreen.field_2779;
	}

	@Override
	public ImmutableRect2i getBookArea(class_518 containerScreen) {
		class_507 guiRecipeBook = containerScreen.method_2659();
		if (guiRecipeBook.method_2605()) {
			int i = (guiRecipeBook.field_3101 - 147) / 2 - guiRecipeBook.field_3102;
			int j = (guiRecipeBook.field_3100 - 166) / 2;
			return new ImmutableRect2i(i, j, 147, 166);
		}
		return ImmutableRect2i.EMPTY;
	}

	@Override
	public ImmutableRect2i getToastsArea() {
		class_310 minecraft = class_310.method_1551();
		class_374 toasts = minecraft.method_1566();
		List<class_374.class_375<?>> visible = toasts.field_2239;
		if (visible.isEmpty()) {
			return ImmutableRect2i.EMPTY;
		}
		int height = 0;
		int width = 0;
		for (class_374.class_375<?> instance : visible) {
			class_368 toast = instance.method_2001();
			height += toast.method_29050();
			width = Math.max(toast.method_29049(), width);
		}
		class_1041 window = minecraft.method_22683();
		int screenWidth = window.method_4486();
		return new ImmutableRect2i(screenWidth - width, 0, width, height);
	}

	@Override
	public List<class_512> getTabButtons(class_507 recipeBookComponent) {
		return recipeBookComponent.field_3094;
	}

	@Override
	public boolean canLoseFocus(class_342 editBox) {
		return editBox.field_2096;
	}
}
