package mezz.jei.gui.elements;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.common.Internal;
import mezz.jei.common.gui.elements.DrawableNineSliceTexture;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.input.IInternalKeyMappings;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.gui.input.IUserInputHandler;
import mezz.jei.gui.input.UserInput;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_768;
import java.util.Optional;

/**
 * A gui button that has an {@link IDrawable} instead of a string label.
 */
public class GuiIconButton extends class_4185 {
	private IDrawable icon;
	private boolean pressed = false;
	private boolean forcePressed = false;

	public GuiIconButton(int x, int y, int width, int height, IDrawable icon, class_4241 pressable) {
		super(x, y, width, height, class_5244.field_39003, pressable, class_4185.field_40754);
		this.icon = icon;
	}

	public GuiIconButton(IDrawable icon, class_4241 pressable) {
		super(0, 0, 0, 0, class_5244.field_39003, pressable, class_4185.field_40754);
		this.icon = icon;
	}

	public void updateBounds(class_768 area) {
		method_46421(area.method_3321());
		method_46419(area.method_3322());
		this.field_22758 = area.method_3319();
		this.field_22759 = area.method_3320();
	}

	public void updateBounds(ImmutableRect2i area) {
		method_46421(area.getX());
		method_46419(area.getY());
		this.field_22758 = area.getWidth();
		this.field_22759 = area.getHeight();
	}

	@Override
	public void method_53533(int value) {
		this.field_22759 = value;
	}

	@Override
	public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
		RenderSystem.setShaderColor(1.0F, 1.0F, 1.0F, 1.0F);
		boolean hovered =
				mouseX >= this.method_46426() &&
						mouseY >= this.method_46427() &&
						mouseX < this.method_46426() + this.field_22758 &&
						mouseY < this.method_46427() + this.field_22759;
		RenderSystem.enableBlend();
		RenderSystem.blendFuncSeparate(
				GlStateManager.class_4535.SRC_ALPHA,
				GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA,
				GlStateManager.class_4535.ONE,
				GlStateManager.class_4534.ZERO
		);
		RenderSystem.blendFunc(GlStateManager.class_4535.SRC_ALPHA, GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
		Textures textures = Internal.getTextures();
		boolean isPressed = this.pressed || this.forcePressed;
		DrawableNineSliceTexture texture = textures.getButtonForState(isPressed, this.field_22763, hovered);
		texture.draw(guiGraphics, this.method_46426(), this.method_46427(), this.field_22758, this.field_22759);

		int color = 0xFFE0E0E0;
		if (!this.field_22763) {
			color = 0xFFA0A0A0;
		} else if (hovered) {
			color = 0xFFFFFFFF;
		}

		float red = (color >> 16 & 255) / 255.0F;
		float blue = (color >> 8 & 255) / 255.0F;
		float green = (color & 255) / 255.0F;
		float alpha = (color >> 24 & 255) / 255.0F;
		RenderSystem.setShaderColor(red, blue, green, alpha);

		double xOffset = method_46426() + (field_22758 - icon.getWidth()) / 2.0;
		double yOffset = method_46427() + (field_22759 - icon.getHeight()) / 2.0;
		if (isPressed) {
			xOffset += 0.5;
			yOffset += 0.5;
		}
		var poseStack = guiGraphics.method_51448();
		poseStack.method_22903();
		{
			poseStack.method_22904(xOffset, yOffset, 0);
			icon.draw(guiGraphics);
		}
		poseStack.method_22909();
		RenderSystem.setShaderColor(1.0F, 1.0F, 1.0F, 1.0F);
	}

	public IUserInputHandler createInputHandler() {
		return new UserInputHandler(this);
	}

	public void setForcePressed(boolean forcePressed) {
		this.forcePressed = forcePressed;
	}

	public ImmutableRect2i getArea() {
		return new ImmutableRect2i(method_46426(), method_46427(), field_22758, field_22759);
	}

	public void setIcon(IDrawable icon) {
		this.icon = icon;
	}

	private class UserInputHandler implements IUserInputHandler {
		private final GuiIconButton button;

		public UserInputHandler(GuiIconButton button) {
			this.button = button;
		}

		@Override
		public Optional<IUserInputHandler> handleUserInput(class_437 screen, UserInput input, IInternalKeyMappings keyBindings) {
			this.button.pressed = false;

			double mouseX = input.getMouseX();
			double mouseY = input.getMouseY();
			if (!this.button.field_22763 || !this.button.field_22764 || !method_25405(mouseX, mouseY)) {
				return Optional.empty();
			}
			if (!this.button.method_25351(input.getKey().method_1444())) {
				return Optional.empty();
			}
			boolean flag = this.button.method_25361(mouseX, mouseY);
			if (!flag) {
				return Optional.empty();
			}
			if (!input.isSimulate()) {
				this.button.method_25354(class_310.method_1551().method_1483());
				this.button.method_25348(mouseX, mouseY);
			} else {
				this.button.pressed = true;
			}
			return Optional.of(this);
		}

		@Override
		public void unfocus() {
			this.button.pressed = false;
		}
	}
}
