/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.overlay.bookmarks.history;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import mezz.jei.api.helpers.IColorHelper;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.config.HistoryDisplaySide;
import mezz.jei.common.config.IClientConfig;
import mezz.jei.common.config.IClientToggleState;
import mezz.jei.common.config.IIngredientFilterConfig;
import mezz.jei.common.config.IIngredientGridConfig;
import mezz.jei.common.input.IInternalKeyMappings;
import mezz.jei.common.network.IConnectionToServer;
import mezz.jei.common.util.ImmutablePoint2i;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.gui.ingredients.GuiIngredientProperties;
import mezz.jei.gui.input.IClickableIngredientInternal;
import mezz.jei.gui.input.IDraggableIngredientInternal;
import mezz.jei.gui.input.IRecipeFocusSource;
import mezz.jei.gui.overlay.IIngredientGridSource;
import mezz.jei.gui.overlay.IngredientGrid;
import mezz.jei.gui.overlay.elements.IElement;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import net.minecraft.class_9801;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class LookupHistoryOverlay
implements IRecipeFocusSource {
    private static final int INGREDIENT_PADDING = 1;
    public static final int SLOT_HEIGHT = GuiIngredientProperties.getHeight(1);
    private final IngredientGrid contents;
    private final IIngredientGridSource lookupHistory;
    private final IClientConfig clientConfig;
    private final HistoryDisplaySide ownerDisplaySide;
    private int rows;

    public LookupHistoryOverlay(IIngredientManager ingredientManager, IIngredientGridSource lookupHistory, IInternalKeyMappings keyMappings, IIngredientGridConfig historyListConfig, IIngredientFilterConfig ingredientFilterConfig, IClientConfig clientConfig, HistoryDisplaySide ownerDisplaySide, IClientToggleState toggleState, IConnectionToServer serverConnection, IColorHelper colorHelper) {
        this.clientConfig = clientConfig;
        this.lookupHistory = lookupHistory;
        this.contents = new IngredientGrid(ingredientManager, historyListConfig, ingredientFilterConfig, clientConfig, toggleState, serverConnection, keyMappings, colorHelper, false);
        this.ownerDisplaySide = ownerDisplaySide;
        lookupHistory.addSourceListChangedListener(this::updateLayout);
    }

    public boolean isListDisplayed() {
        return this.clientConfig.isLookupHistoryEnabled() && this.isOnSide() && this.contents.hasRoom();
    }

    public boolean isOnSide() {
        return this.ownerDisplaySide.equals((Object)this.clientConfig.getLookupHistoryDisplaySide());
    }

    public IIngredientGridSource getLookupHistory() {
        return this.lookupHistory;
    }

    public void updateBounds(ImmutableRect2i availableArea, Set<ImmutableRect2i> guiExclusionAreas, @Nullable ImmutablePoint2i mouseExclusionPoint) {
        this.contents.updateBounds(availableArea, guiExclusionAreas, mouseExclusionPoint);
        int rows = this.contents.getArea().getHeight() / SLOT_HEIGHT;
        this.rows = Math.min(rows, this.clientConfig.getMaxLookupHistoryRows());
    }

    public void updateLayout() {
        List<IElement<?>> ingredientList = this.lookupHistory.getElements();
        this.contents.set(0, ingredientList);
    }

    private void drawLine(class_4587 poseStack, int x1, int x2, int y, int argbColor) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34540);
        class_289 tesselator = class_289.method_1348();
        class_287 builder = tesselator.method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        float a = (float)(argbColor >> 24 & 0xFF) / 255.0f;
        float r = (float)(argbColor >> 16 & 0xFF) / 255.0f;
        float g = (float)(argbColor >> 8 & 0xFF) / 255.0f;
        float b = (float)(argbColor & 0xFF) / 255.0f;
        Matrix4f pose = poseStack.method_23760().method_23761();
        int availableWidth = x2 - x1;
        if (availableWidth <= 0) {
            return;
        }
        int dashWidth = 8;
        boolean dashHeight = true;
        int spacing = 6;
        int interval = 14;
        int dashCount = availableWidth / 14;
        float floatInterval = (float)(availableWidth - 8) / (float)dashCount;
        for (float x = (float)x1; x < (float)x2; x += floatInterval) {
            builder.method_22918(pose, class_3532.method_15363((float)(x + 8.0f), (float)x1, (float)x2), (float)y, 0.0f).method_22915(r, g, b, a);
            builder.method_22918(pose, class_3532.method_15363((float)x, (float)x1, (float)x2), (float)y, 0.0f).method_22915(r, g, b, a);
            builder.method_22918(pose, class_3532.method_15363((float)x, (float)x1, (float)x2), (float)(y + 1), 0.0f).method_22915(r, g, b, a);
            builder.method_22918(pose, class_3532.method_15363((float)(x + 8.0f), (float)x1, (float)x2), (float)(y + 1), 0.0f).method_22915(r, g, b, a);
        }
        class_286.method_43433((class_9801)builder.method_60800());
        RenderSystem.disableBlend();
    }

    public void draw(class_310 minecraft, class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.isListDisplayed()) {
            this.contents.draw(minecraft, guiGraphics, mouseX, mouseY);
            ImmutableRect2i area = this.contents.getArea();
            int endX = area.getX() + area.getWidth();
            int startY = area.getY() + area.getHeight() - this.rows * SLOT_HEIGHT - 3;
            int color = -6974059;
            this.drawLine(guiGraphics.method_51448(), area.getX(), endX, startY, color);
        }
    }

    public void drawTooltips(class_310 minecraft, class_332 guiGraphics, int mouseX, int mouseY) {
        if (this.isListDisplayed()) {
            this.contents.drawTooltips(minecraft, guiGraphics, mouseX, mouseY);
        }
    }

    public ImmutableRect2i getArea() {
        return this.contents.getArea();
    }

    @Override
    public Stream<IClickableIngredientInternal<?>> getIngredientUnderMouse(double mouseX, double mouseY) {
        if (this.isListDisplayed()) {
            return this.contents.getIngredientUnderMouse(mouseX, mouseY);
        }
        return Stream.empty();
    }

    @Override
    public Stream<IDraggableIngredientInternal<?>> getDraggableIngredientUnderMouse(double mouseX, double mouseY) {
        if (this.isListDisplayed()) {
            return this.contents.getDraggableIngredientUnderMouse(mouseX, mouseY);
        }
        return Stream.empty();
    }
}

