package mezz.jei.common.util;

import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.class_6862;
import net.minecraft.class_6885;

public class TagUtil {
	public static <VALUE, STACK> Optional<class_6862<?>> getTagEquivalent(
		Collection<STACK> stacks,
		Function<STACK, VALUE> stackToValue,
		Supplier<Stream<Pair<class_6862<VALUE>, class_6885.class_6888<VALUE>>>> tagSupplier
	) {
		List<VALUE> values = stacks.stream()
			.map(stackToValue)
			.toList();

		return tagSupplier.get()
			.filter(e -> {
				class_6885.class_6888<VALUE> tag = e.getSecond();
				return areEquivalent(tag, values);
			})
			.<class_6862<?>>map(Pair::getFirst)
			.findFirst();
	}

	private static <VALUE> boolean areEquivalent(class_6885.class_6888<VALUE> tag, List<VALUE> values) {
		int count = tag.method_40247();
		if (count != values.size()) {
			return false;
		}
		for (int i = 0; i < count; i++) {
			VALUE tagValue = tag.method_40240(i).comp_349();
			VALUE value = values.get(i);
			if (!value.equals(tagValue)) {
				return false;
			}
		}
		return true;
	}
}
