package mezz.jei.api.recipe.vanilla;

import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2960;

/**
 * There is no vanilla registry of Grindstone Recipes,
 * so JEI creates these Grindstone recipes to use internally.
 *
 * Create your own with {@link IVanillaRecipeFactory#createGrindstoneRecipe}
 * @since 19.22.1
 */
public interface IJeiGrindstoneRecipe {
	/**
	 * Get the inputs that go into the top slot of the Grindstone.
	 *
	 * @since 19.22.1
	 */
	@Unmodifiable
	List<class_1799> getTopInputs();

	/**
	 * Get the inputs that go into the bottom slot of the Grindstone.
	 *
	 * @since 19.22.1
	 */
	@Unmodifiable
	List<class_1799> getBottomInputs();

	/**
	 * Get the outputs of the Grindstone recipe.
	 *
	 * @since 19.22.1
	 */
	@Unmodifiable
	List<class_1799> getOutputs();

	/**
	 * The minimum XP that a player can receive.
	 *
	 * @since 19.22.1
	 */
	int getMinXpReward();

	/**
	 * The maximum XP that a player can receive.
	 *
	 * @since 19.22.1
	 */
	int getMaxXpReward();

	/**
	 * Unique ID for this recipe.
	 *
	 * @since 19.22.1
	 */
	@Nullable
	class_2960 getUid();

	/**
	 * Make the output render only, to avoid displaying unnecessary crafting recipes when looking up outputs.
	 *
	 * @since 19.22.1
	 */
	@Unmodifiable
	boolean isOutputRenderOnly();
}
