package mezz.jei.api.helpers;

import mezz.jei.api.ingredients.IIngredientTypeWithSubtypes;
import net.minecraft.class_3611;
import net.minecraft.class_6880;
import net.minecraft.class_9326;

/**
 * Helper for mods that want to handle Fluid ingredients across multiple platforms (Forge and Fabric).
 * @param <T> the type of Fluid ingredient for the current platform.
 * @since 10.1.0
 */
public interface IPlatformFluidHelper<T> {
	/**
	 * Returns the type of Fluid ingredients on the current platform.
	 * @since 10.1.0
	 */
	IIngredientTypeWithSubtypes<class_3611, T> getFluidIngredientType();

	/**
	 * Creates a new fluid ingredient for the current platform.
	 * @since 18.0.0
	 */
	T create(class_6880<class_3611> fluid, long amount, class_9326 components);

	/**
	 * Creates a new fluid ingredient for the current platform.
	 * @since 18.0.0
	 */
	T create(class_6880<class_3611> fluid, long amount);

	/**
	 * Returns amount of Fluid in one bucket on the current platform.
	 * @since 10.1.0
	 */
	long bucketVolume();
}
