/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.vanilla.IJeiBrewingRecipe;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.platform.IPlatformIngredientHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.RegistryWrapper;
import mezz.jei.library.ingredients.IngredientSet;
import mezz.jei.library.plugins.vanilla.brewing.PotionSubtypeInterpreter;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1812;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1845;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_9334;

public class BrewingRecipeMakerCommon {
    public static Set<IJeiBrewingRecipe> getVanillaBrewingRecipes(IVanillaRecipeFactory recipeFactory, IIngredientManager ingredientManager, class_1845 potionBrewing) {
        boolean foundNewPotions;
        HashSet<IJeiBrewingRecipe> recipes = new HashSet<IJeiBrewingRecipe>();
        RegistryWrapper<class_1842> potionRegistry = RegistryWrapper.getRegistry(class_7924.field_41215);
        IIngredientHelper itemStackHelper = ingredientManager.getIngredientHelper(VanillaTypes.ITEM_STACK);
        IngredientSet<class_1799> knownPotions = BrewingRecipeMakerCommon.getBaseKnownPotions(ingredientManager, potionRegistry, potionBrewing);
        IPlatformIngredientHelper ingredientHelper = Services.PLATFORM.getIngredientHelper();
        IngredientSet potionReagents = ingredientHelper.getPotionIngredients(potionBrewing).flatMap(i -> Arrays.stream(i.method_8105())).collect(Collectors.toCollection(() -> IngredientSet.create(itemStackHelper, UidContext.Ingredient)));
        do {
            List<class_1799> newPotions;
            foundNewPotions = !(newPotions = BrewingRecipeMakerCommon.getNewPotions(potionBrewing, recipeFactory, knownPotions, potionReagents, recipes)).isEmpty();
            knownPotions.addAll(newPotions);
        } while (foundNewPotions);
        return recipes;
    }

    private static IngredientSet<class_1799> getBaseKnownPotions(IIngredientManager ingredientManager, RegistryWrapper<class_1842> potionRegistry, class_1845 potionBrewing) {
        IPlatformIngredientHelper ingredientHelper = Services.PLATFORM.getIngredientHelper();
        IIngredientHelper itemStackHelper = ingredientManager.getIngredientHelper(VanillaTypes.ITEM_STACK);
        IngredientSet potionContainers = ingredientHelper.getPotionContainers(potionBrewing).stream().flatMap(potionItem -> Arrays.stream(potionItem.method_8105())).collect(Collectors.toCollection(() -> IngredientSet.create(itemStackHelper, UidContext.Ingredient)));
        IngredientSet<class_1799> knownPotions = IngredientSet.create(itemStackHelper, UidContext.Ingredient);
        knownPotions.addAll(potionContainers);
        potionRegistry.getHolderStream().forEach(potion -> {
            for (class_1799 potionContainer : potionContainers) {
                class_1799 result = class_1844.method_57400((class_1792)potionContainer.method_7909(), (class_6880)potion);
                knownPotions.add(result);
            }
        });
        return knownPotions;
    }

    private static List<class_1799> getNewPotions(class_1845 potionBrewing, IVanillaRecipeFactory recipeFactory, Collection<class_1799> knownPotions, Collection<class_1799> potionReagents, Collection<IJeiBrewingRecipe> recipes) {
        ArrayList<class_1799> newPotions = new ArrayList<class_1799>();
        for (class_1799 potionInput : knownPotions) {
            for (class_1799 potionReagent : potionReagents) {
                IJeiBrewingRecipe recipe;
                String outputId;
                String inputId;
                Optional potionOutputType;
                class_1799 potionOutput = BrewingRecipeMakerCommon.getOutput(potionBrewing, potionInput.method_7972(), potionReagent);
                if (potionOutput.method_7960() || potionInput.method_7909() instanceof class_1812 && potionOutput.method_7909() instanceof class_1812 && ((potionOutputType = ((class_1844)potionOutput.method_57825(class_9334.field_49651, (Object)class_1844.field_49274)).comp_2378()).isEmpty() || Objects.equals(inputId = PotionSubtypeInterpreter.INSTANCE.apply(potionInput, UidContext.Recipe), outputId = PotionSubtypeInterpreter.INSTANCE.apply(potionOutput, UidContext.Recipe))) || recipes.contains(recipe = recipeFactory.createBrewingRecipe(List.of(potionReagent), potionInput.method_7972(), potionOutput))) continue;
                recipes.add(recipe);
                newPotions.add(potionOutput);
            }
        }
        return newPotions;
    }

    private static class_1799 getOutput(class_1845 potionBrewing, class_1799 potion, class_1799 itemStack) {
        class_1799 result = potionBrewing.method_8078(itemStack, potion);
        if (result != itemStack) {
            return result;
        }
        return class_1799.field_8037;
    }
}

