/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.config;

import java.util.function.Supplier;
import mezz.jei.common.config.IIngredientFilterConfig;
import mezz.jei.common.config.file.IConfigCategoryBuilder;
import mezz.jei.common.config.file.IConfigSchemaBuilder;
import mezz.jei.core.search.SearchMode;

public class IngredientFilterConfig
implements IIngredientFilterConfig {
    public final Supplier<SearchMode> modNameSearchMode;
    public final Supplier<SearchMode> tooltipSearchMode;
    public final Supplier<SearchMode> tagSearchMode;
    public final Supplier<SearchMode> colorSearchMode;
    public final Supplier<SearchMode> resourceLocationSearchMode;
    public final Supplier<Boolean> searchAdvancedTooltips;
    public final Supplier<Boolean> searchModIds;
    public final Supplier<Boolean> searchModAliases;
    public final Supplier<Boolean> searchShortModNames;

    public IngredientFilterConfig(IConfigSchemaBuilder builder) {
        IConfigCategoryBuilder search = builder.addCategory("search");
        this.modNameSearchMode = search.addEnum("ModNameSearchMode", SearchMode.REQUIRE_PREFIX, "Search mode for mod names (prefix: @).");
        this.tooltipSearchMode = search.addEnum("TooltipSearchMode", SearchMode.ENABLED, "Search mode for tooltips (prefix: #).");
        this.tagSearchMode = search.addEnum("TagSearchMode", SearchMode.REQUIRE_PREFIX, "Search mode for tags (prefix: $).");
        this.colorSearchMode = search.addEnum("ColorSearchMode", SearchMode.DISABLED, "Search mode for colors (prefix: ^).");
        this.resourceLocationSearchMode = search.addEnum("ResourceLocationSearchMode", SearchMode.DISABLED, "Search mode for resource locations (prefix: &).");
        this.searchAdvancedTooltips = search.addBoolean("SearchAdvancedTooltips", false, "Search in advanced tooltips (visible with F3 + H).");
        this.searchModIds = search.addBoolean("SearchModIds", true, "Search mod IDs in addition to mod names.");
        this.searchModAliases = search.addBoolean("SearchModAliases", true, "Search mod aliases (alternative names) that are added by plugins, in addition to mod names.");
        this.searchShortModNames = search.addBoolean("SearchShortModNames", true, "Search by the shorthand first letters of a mod's name.");
    }

    @Override
    public SearchMode getModNameSearchMode() {
        return this.modNameSearchMode.get();
    }

    @Override
    public SearchMode getTooltipSearchMode() {
        return this.tooltipSearchMode.get();
    }

    @Override
    public SearchMode getTagSearchMode() {
        return this.tagSearchMode.get();
    }

    @Override
    public SearchMode getColorSearchMode() {
        return this.colorSearchMode.get();
    }

    @Override
    public SearchMode getResourceLocationSearchMode() {
        return this.resourceLocationSearchMode.get();
    }

    @Override
    public boolean getSearchAdvancedTooltips() {
        return this.searchAdvancedTooltips.get();
    }

    @Override
    public boolean getSearchModIds() {
        return this.searchModIds.get();
    }

    @Override
    public boolean getSearchModAliases() {
        return this.searchModAliases.get();
    }

    @Override
    public boolean getSearchShortModNames() {
        return this.searchShortModNames.get();
    }
}

