/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.vanilla.ingredients;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.common.util.StackHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ItemStackListFactory {
    private static final Logger LOGGER = LogManager.getLogger();

    public static List<ItemStack> create(StackHelper stackHelper) {
        ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
        HashSet<String> itemNameSet = new HashSet<String>();
        Minecraft minecraft = Minecraft.getInstance();
        FeatureFlagSet features = Optional.of(minecraft).map(m -> m.player).map(p -> p.connection).map(ClientPacketListener::enabledFeatures).orElse(FeatureFlagSet.of());
        boolean hasPermissions = (Boolean)minecraft.options.operatorItemsTab().get() != false || Optional.of(minecraft).map(m -> m.player).map(Player::canUseGameMasterBlocks).orElse(false) != false;
        ClientLevel level = minecraft.level;
        if (level == null) {
            throw new NullPointerException("minecraft.level must be set before JEI fetches ingredients");
        }
        RegistryAccess registryAccess = level.registryAccess();
        CreativeModeTab.ItemDisplayParameters displayParameters = new CreativeModeTab.ItemDisplayParameters(features, hasPermissions, (HolderLookup.Provider)registryAccess);
        for (CreativeModeTab itemGroup : CreativeModeTabs.allTabs()) {
            Collection creativeTabItemStacks;
            if (itemGroup.getType() != CreativeModeTab.Type.CATEGORY) continue;
            try {
                itemGroup.buildContents(displayParameters);
            }
            catch (LinkageError | RuntimeException e) {
                LOGGER.error("Item Group crashed while building contents.Items from this group will be missing from the JEI ingredient list. {}", (Object)itemGroup, (Object)e);
                continue;
            }
            try {
                creativeTabItemStacks = itemGroup.getSearchTabDisplayItems();
            }
            catch (LinkageError | RuntimeException e) {
                LOGGER.error("Item Group crashed while getting display items.Some items from this group will be missing from the JEI ingredient list. {}", (Object)itemGroup, (Object)e);
                continue;
            }
            for (ItemStack itemStack : creativeTabItemStacks) {
                if (itemStack.isEmpty()) {
                    LOGGER.error("Found an empty itemStack from creative tab: {}", (Object)itemGroup);
                    continue;
                }
                ItemStackListFactory.addItemStack(stackHelper, itemStack, itemList, itemNameSet);
            }
        }
        return itemList;
    }

    private static void addItemStack(StackHelper stackHelper, ItemStack stack, List<ItemStack> itemList, Set<String> itemNameSet) {
        String itemKey;
        try {
            itemKey = stackHelper.getUniqueIdentifierForStack(stack, UidContext.Ingredient);
        }
        catch (LinkageError | RuntimeException e) {
            String stackInfo = ErrorUtil.getItemStackInfo((ItemStack)stack);
            LOGGER.error("Couldn't get unique name for itemStack {}", (Object)stackInfo, (Object)e);
            return;
        }
        if (!itemNameSet.contains(itemKey)) {
            itemNameSet.add(itemKey);
            itemList.add(stack);
        }
    }
}

