/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.vanilla.crafting;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.library.plugins.vanilla.crafting.CategoryRecipeValidator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.Container;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.SmokingRecipe;
import net.minecraft.world.item.crafting.StonecutterRecipe;

public final class VanillaRecipes {
    private final RecipeManager recipeManager;
    private final IIngredientManager ingredientManager;

    public VanillaRecipes(IIngredientManager ingredientManager) {
        Minecraft minecraft = Minecraft.getInstance();
        ErrorUtil.checkNotNull((Object)minecraft, (String)"minecraft");
        ClientLevel world = minecraft.level;
        ErrorUtil.checkNotNull((Object)world, (String)"minecraft world");
        this.recipeManager = world.getRecipeManager();
        this.ingredientManager = ingredientManager;
    }

    public Map<Boolean, List<RecipeHolder<CraftingRecipe>>> getCraftingRecipes(IRecipeCategory<RecipeHolder<CraftingRecipe>> craftingCategory) {
        CategoryRecipeValidator<CraftingRecipe> validator = new CategoryRecipeValidator<CraftingRecipe>(craftingCategory, this.ingredientManager, 9);
        return this.recipeManager.getAllRecipesFor(RecipeType.CRAFTING).stream().filter(validator::isRecipeValid).collect(Collectors.partitioningBy(validator::isRecipeHandled));
    }

    public List<RecipeHolder<StonecutterRecipe>> getStonecuttingRecipes(IRecipeCategory<RecipeHolder<StonecutterRecipe>> stonecuttingCategory) {
        CategoryRecipeValidator<StonecutterRecipe> validator = new CategoryRecipeValidator<StonecutterRecipe>(stonecuttingCategory, this.ingredientManager, 1);
        return VanillaRecipes.getValidHandledRecipes(this.recipeManager, RecipeType.STONECUTTING, validator);
    }

    public List<RecipeHolder<SmeltingRecipe>> getFurnaceRecipes(IRecipeCategory<RecipeHolder<SmeltingRecipe>> furnaceCategory) {
        CategoryRecipeValidator<SmeltingRecipe> validator = new CategoryRecipeValidator<SmeltingRecipe>(furnaceCategory, this.ingredientManager, 1);
        return VanillaRecipes.getValidHandledRecipes(this.recipeManager, RecipeType.SMELTING, validator);
    }

    public List<RecipeHolder<SmokingRecipe>> getSmokingRecipes(IRecipeCategory<RecipeHolder<SmokingRecipe>> smokingCategory) {
        CategoryRecipeValidator<SmokingRecipe> validator = new CategoryRecipeValidator<SmokingRecipe>(smokingCategory, this.ingredientManager, 1);
        return VanillaRecipes.getValidHandledRecipes(this.recipeManager, RecipeType.SMOKING, validator);
    }

    public List<RecipeHolder<BlastingRecipe>> getBlastingRecipes(IRecipeCategory<RecipeHolder<BlastingRecipe>> blastingCategory) {
        CategoryRecipeValidator<BlastingRecipe> validator = new CategoryRecipeValidator<BlastingRecipe>(blastingCategory, this.ingredientManager, 1);
        return VanillaRecipes.getValidHandledRecipes(this.recipeManager, RecipeType.BLASTING, validator);
    }

    public List<RecipeHolder<CampfireCookingRecipe>> getCampfireCookingRecipes(IRecipeCategory<RecipeHolder<CampfireCookingRecipe>> campfireCategory) {
        CategoryRecipeValidator<CampfireCookingRecipe> validator = new CategoryRecipeValidator<CampfireCookingRecipe>(campfireCategory, this.ingredientManager, 1);
        return VanillaRecipes.getValidHandledRecipes(this.recipeManager, RecipeType.CAMPFIRE_COOKING, validator);
    }

    public List<RecipeHolder<SmithingRecipe>> getSmithingRecipes(IRecipeCategory<RecipeHolder<SmithingRecipe>> smithingCategory) {
        CategoryRecipeValidator<SmithingRecipe> validator = new CategoryRecipeValidator<SmithingRecipe>(smithingCategory, this.ingredientManager, 0);
        return VanillaRecipes.getValidHandledRecipes(this.recipeManager, RecipeType.SMITHING, validator);
    }

    private static <C extends Container, T extends Recipe<C>> List<RecipeHolder<T>> getValidHandledRecipes(RecipeManager recipeManager, RecipeType<T> recipeType, CategoryRecipeValidator<T> validator) {
        return recipeManager.getAllRecipesFor(recipeType).stream().filter(r -> validator.isRecipeValid((RecipeHolder)r) && validator.isRecipeHandled((RecipeHolder)r)).toList();
    }
}

