/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.ingredients.subtypes;

import mezz.jei.api.ingredients.IIngredientTypeWithSubtypes;
import mezz.jei.api.ingredients.subtypes.ISubtypeManager;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.library.ingredients.subtypes.SubtypeInterpreters;

public class SubtypeManager
implements ISubtypeManager {
    private final SubtypeInterpreters interpreters;

    public SubtypeManager(SubtypeInterpreters interpreters) {
        this.interpreters = interpreters;
    }

    public <T> String getSubtypeInfo(IIngredientTypeWithSubtypes<?, T> ingredientType, T ingredient, UidContext context) {
        ErrorUtil.checkNotNull(ingredientType, (String)"ingredientType");
        ErrorUtil.checkNotNull(ingredient, (String)"ingredient");
        ErrorUtil.checkNotNull((Object)context, (String)"context");
        return this.interpreters.get(ingredientType, ingredient).map(subtypeInterpreter -> subtypeInterpreter.apply(ingredient, context)).orElse("");
    }
}

