/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.config;

import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import mezz.jei.api.runtime.config.IJeiConfigValueSerializer;
import mezz.jei.common.config.file.IConfigCategoryBuilder;
import mezz.jei.common.config.file.IConfigSchemaBuilder;
import mezz.jei.common.platform.IPlatformItemStackHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.core.util.function.CachedSupplierTransformer;
import mezz.jei.library.config.IModIdFormatConfig;
import mezz.jei.library.config.serializers.ChatFormattingSerializer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class ModIdFormatConfig
implements IModIdFormatConfig {
    protected static final List<ChatFormatting> defaultModNameFormat = List.of(ChatFormatting.BLUE, ChatFormatting.ITALIC);
    public static final String MOD_NAME_FORMAT_CODE = "%MODNAME%";
    private final Supplier<String> modNameFormat;
    @Nullable
    private String cachedOverride;

    public ModIdFormatConfig(IConfigSchemaBuilder builder) {
        IConfigCategoryBuilder modName = builder.addCategory("modname");
        Supplier configValue = modName.addList("ModNameFormat", defaultModNameFormat, (IJeiConfigValueSerializer)ChatFormattingSerializer.INSTANCE, "Formatting for the mod names in tooltips for JEI GUIs. Leave blank to disable.");
        this.modNameFormat = new CachedSupplierTransformer(configValue, ModIdFormatConfig::toFormatString);
    }

    private static String toFormatString(List<ChatFormatting> values) {
        return values.stream().map(ChatFormatting::toString).collect(Collectors.joining());
    }

    private String getOverride() {
        if (this.cachedOverride == null) {
            this.cachedOverride = this.detectModNameTooltipFormatting();
        }
        return this.cachedOverride;
    }

    @Override
    public final String getModNameFormat() {
        String override = this.getOverride();
        if (!override.isEmpty()) {
            return override;
        }
        return this.modNameFormat.get();
    }

    @Override
    public final boolean isModNameFormatOverrideActive() {
        return !this.getOverride().isEmpty();
    }

    private String detectModNameTooltipFormatting() {
        IPlatformItemStackHelper itemStackHelper = Services.PLATFORM.getItemStackHelper();
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        List tooltip = itemStackHelper.getTestTooltip((Player)player, new ItemStack((ItemLike)Items.APPLE));
        if (tooltip.size() <= 1) {
            return "";
        }
        for (int lineNum = 1; lineNum < tooltip.size(); ++lineNum) {
            String withoutFormatting;
            Component line = (Component)tooltip.get(lineNum);
            String lineString = line.getString();
            if (!lineString.contains("Minecraft") || (withoutFormatting = ChatFormatting.stripFormatting((String)lineString)) == null || !withoutFormatting.contains("Minecraft")) continue;
            return StringUtils.replaceOnce((String)lineString, (String)"Minecraft", (String)MOD_NAME_FORMAT_CODE);
        }
        return "";
    }
}

