/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes;

import java.util.List;
import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferManager;
import mezz.jei.common.gui.TooltipRenderer;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.transfer.RecipeTransferErrorInternal;
import mezz.jei.common.transfer.RecipeTransferUtil;
import mezz.jei.gui.elements.GuiIconButtonSmall;
import mezz.jei.gui.recipes.IOnClickHandler;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.Nullable;

public class RecipeTransferButton
extends GuiIconButtonSmall {
    private final IRecipeLayoutDrawable<?> recipeLayout;
    private final Runnable onClose;
    @Nullable
    private IRecipeTransferError recipeTransferError;
    @Nullable
    private IOnClickHandler onClickHandler;

    public RecipeTransferButton(IDrawable icon, IRecipeLayoutDrawable<?> recipeLayout, Textures textures, Runnable onClose) {
        super(0, 0, 0, 0, icon, b -> {}, textures);
        this.recipeLayout = recipeLayout;
        this.onClose = onClose;
    }

    public void update(Rect2i area, IRecipeTransferManager recipeTransferManager, @Nullable AbstractContainerMenu container, Player player) {
        this.setX(area.getX());
        this.setY(area.getY());
        this.width = area.getWidth();
        this.height = area.getHeight();
        this.recipeTransferError = container != null ? (IRecipeTransferError)RecipeTransferUtil.getTransferRecipeError((IRecipeTransferManager)recipeTransferManager, (AbstractContainerMenu)container, this.recipeLayout, (Player)player).orElse(null) : RecipeTransferErrorInternal.INSTANCE;
        if (this.recipeTransferError == null || this.recipeTransferError.getType().allowsTransfer) {
            this.active = true;
            this.visible = true;
        } else {
            this.active = false;
            IRecipeTransferError.Type type = this.recipeTransferError.getType();
            this.visible = type == IRecipeTransferError.Type.USER_FACING;
        }
        this.onClickHandler = (mouseX, mouseY) -> {
            boolean maxTransfer = Screen.hasShiftDown();
            if (container != null && RecipeTransferUtil.transferRecipe((IRecipeTransferManager)recipeTransferManager, (AbstractContainerMenu)container, this.recipeLayout, (Player)player, (boolean)maxTransfer)) {
                this.onClose.run();
            }
        };
    }

    public void drawToolTip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (this.isMouseOver(mouseX, mouseY)) {
            if (this.recipeTransferError == null) {
                MutableComponent tooltipTransfer = Component.translatable((String)"jei.tooltip.transfer");
                TooltipRenderer.drawHoveringText((GuiGraphics)guiGraphics, List.of(tooltipTransfer), (int)mouseX, (int)mouseY);
            } else {
                IRecipeSlotsView recipeSlotsView = this.recipeLayout.getRecipeSlotsView();
                Rect2i recipeRect = this.recipeLayout.getRect();
                this.recipeTransferError.showError(guiGraphics, mouseX, mouseY, recipeSlotsView, recipeRect.getX(), recipeRect.getY());
            }
        }
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return this.visible && mouseX >= (double)this.getX() && mouseY >= (double)this.getY() && mouseX < (double)(this.getX() + this.getWidth()) && mouseY < (double)(this.getY() + this.getHeight());
    }

    @Override
    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.renderWidget(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.recipeTransferError != null && this.recipeTransferError.getType() == IRecipeTransferError.Type.COSMETIC) {
            guiGraphics.fill(RenderType.guiOverlay(), this.getX(), this.getY(), this.getX() + this.getWidth(), this.getY() + this.getHeight(), this.recipeTransferError.getButtonHighlightColor());
        }
    }

    public void onRelease(double mouseX, double mouseY) {
        if (!this.isMouseOver(mouseX, mouseY)) {
            return;
        }
        if (this.onClickHandler != null) {
            this.onClickHandler.onClick(mouseX, mouseY);
        }
    }
}

