/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.ingredients;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.config.IIngredientFilterConfig;
import mezz.jei.common.util.Translator;
import mezz.jei.gui.ingredients.IListElement;
import mezz.jei.gui.ingredients.IListElementInfo;
import mezz.jei.gui.ingredients.IngredientInformationUtil;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ListElementInfo<V>
implements IListElementInfo<V> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final IListElement<V> element;
    private final String displayNameLowercase;
    private final List<String> modIds;
    private final List<String> modNames;
    private final ResourceLocation resourceLocation;
    private int sortedIndex = Integer.MAX_VALUE;

    public static <V> Optional<IListElementInfo<V>> create(IListElement<V> element, IIngredientManager ingredientManager, IModIdHelper modIdHelper) {
        ITypedIngredient<V> value = element.getTypedIngredient();
        IIngredientHelper ingredientHelper = ingredientManager.getIngredientHelper(value.getType());
        try {
            ListElementInfo<V> info = new ListElementInfo<V>(element, ingredientHelper, modIdHelper);
            return Optional.of(info);
        }
        catch (RuntimeException e) {
            try {
                String ingredientInfo = ingredientHelper.getErrorInfo(value.getIngredient());
                LOGGER.warn("Found a broken ingredient {}", (Object)ingredientInfo, (Object)e);
            }
            catch (RuntimeException e2) {
                LOGGER.warn("Found a broken ingredient.", (Throwable)e2);
            }
            return Optional.empty();
        }
    }

    protected ListElementInfo(IListElement<V> element, IIngredientHelper<V> ingredientHelper, IModIdHelper modIdHelper) {
        this.element = element;
        ITypedIngredient<V> value = element.getTypedIngredient();
        Object ingredient = value.getIngredient();
        this.resourceLocation = ingredientHelper.getResourceLocation(ingredient);
        String displayModId = ingredientHelper.getDisplayModId(ingredient);
        String modId = this.resourceLocation.getNamespace();
        this.modIds = Stream.of(displayModId, modId).distinct().toList();
        this.modNames = this.modIds.stream().map(arg_0 -> ((IModIdHelper)modIdHelper).getModNameForModId(arg_0)).toList();
        String displayName = IngredientInformationUtil.getDisplayName(ingredient, ingredientHelper);
        this.displayNameLowercase = Translator.toLowercaseWithLocale((String)displayName);
    }

    @Override
    public String getName() {
        return this.displayNameLowercase;
    }

    @Override
    public String getModNameForSorting() {
        return this.modNames.get(0);
    }

    @Override
    public List<String> getModNames() {
        return this.modNames;
    }

    @Override
    public List<String> getModIds() {
        return this.modIds;
    }

    @Override
    public final List<String> getTooltipStrings(IIngredientFilterConfig config, IIngredientManager ingredientManager) {
        String modName = this.modNames.get(0);
        String modId = this.modIds.get(0);
        String modNameLowercase = modName.toLowerCase(Locale.ENGLISH);
        ITypedIngredient<V> value = this.element.getTypedIngredient();
        IIngredientRenderer ingredientRenderer = ingredientManager.getIngredientRenderer(value.getType());
        ImmutableSet toRemove = ImmutableSet.of((Object)modId, (Object)modNameLowercase, (Object)this.displayNameLowercase, (Object)this.resourceLocation.getPath());
        return IngredientInformationUtil.getTooltipStrings(value.getIngredient(), ingredientRenderer, (Set<String>)toRemove, config);
    }

    @Override
    public Collection<String> getTagStrings(IIngredientManager ingredientManager) {
        ITypedIngredient<V> value = this.element.getTypedIngredient();
        IIngredientHelper ingredientHelper = ingredientManager.getIngredientHelper(value.getType());
        return ingredientHelper.getTagStream(value.getIngredient()).map(ResourceLocation::getPath).toList();
    }

    @Override
    public Stream<ResourceLocation> getTagIds(IIngredientManager ingredientManager) {
        ITypedIngredient<V> value = this.element.getTypedIngredient();
        IIngredientHelper ingredientHelper = ingredientManager.getIngredientHelper(value.getType());
        return ingredientHelper.getTagStream(value.getIngredient());
    }

    @Override
    public Iterable<Integer> getColors(IIngredientManager ingredientManager) {
        ITypedIngredient<V> value = this.element.getTypedIngredient();
        IIngredientHelper ingredientHelper = ingredientManager.getIngredientHelper(value.getType());
        Object ingredient = value.getIngredient();
        return ingredientHelper.getColors(ingredient);
    }

    @Override
    public ResourceLocation getResourceLocation() {
        return this.resourceLocation;
    }

    @Override
    public IListElement<V> getElement() {
        return this.element;
    }

    @Override
    public ITypedIngredient<V> getTypedIngredient() {
        return this.element.getTypedIngredient();
    }

    @Override
    public void setSortedIndex(int sortIndex) {
        this.sortedIndex = sortIndex;
    }

    @Override
    public int getSortedIndex() {
        return this.sortedIndex;
    }
}

