/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.gui.elements;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.ingredients.IIngredientRenderer;
import net.minecraft.client.gui.GuiGraphics;

public class DrawableIngredient<V>
implements IDrawable {
    private final V ingredient;
    private final IIngredientRenderer<V> ingredientRenderer;

    public DrawableIngredient(V ingredient, IIngredientRenderer<V> ingredientRenderer) {
        this.ingredient = ingredient;
        this.ingredientRenderer = ingredientRenderer;
    }

    public int getWidth() {
        return this.ingredientRenderer.getWidth();
    }

    public int getHeight() {
        return this.ingredientRenderer.getHeight();
    }

    public void draw(GuiGraphics guiGraphics) {
        RenderSystem.enableDepthTest();
        this.ingredientRenderer.render(guiGraphics, this.ingredient);
        RenderSystem.disableDepthTest();
    }

    public void draw(GuiGraphics guiGraphics, int xOffset, int yOffset) {
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate((float)xOffset, (float)yOffset, 0.0f);
        this.draw(guiGraphics);
        poseStack.popPose();
    }
}

