/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.network.packets.handlers;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.common.Internal;
import mezz.jei.common.config.IClientToggleState;
import mezz.jei.common.config.IServerConfig;
import mezz.jei.common.network.ClientPacketContext;
import mezz.jei.common.util.ChatUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.player.LocalPlayer;
import org.jetbrains.annotations.NotNull;

public class ClientCheatPermissionHandler {
    public static void handleHasCheatPermission(ClientPacketContext context, boolean hasPermission) {
        if (!hasPermission) {
            LocalPlayer player = context.player();
            ChatUtil.writeChatMessage(player, "jei.chat.error.no.cheat.permission.1", ChatFormatting.RED);
            List<String> allowedCheatingMethods = ClientCheatPermissionHandler.getAllowedCheatingMethods(context);
            if (allowedCheatingMethods.isEmpty()) {
                ChatUtil.writeChatMessage(player, "jei.chat.error.no.cheat.permission.disabled", ChatFormatting.RED);
            } else {
                ChatUtil.writeChatMessage(player, "jei.chat.error.no.cheat.permission.enabled", ChatFormatting.RED);
                for (String allowedCheatingMethod : allowedCheatingMethods) {
                    ChatUtil.writeChatMessage(player, allowedCheatingMethod, ChatFormatting.RED);
                }
            }
            IClientToggleState toggleState = Internal.getClientToggleState();
            toggleState.setCheatItemsEnabled(false);
            player.closeContainer();
        }
    }

    @NotNull
    private static List<String> getAllowedCheatingMethods(ClientPacketContext context) {
        IServerConfig serverConfig = context.serverConfig();
        ArrayList<String> allowedCheatingMethods = new ArrayList<String>();
        if (serverConfig.isCheatModeEnabledForOp()) {
            allowedCheatingMethods.add("jei.chat.error.no.cheat.permission.op");
        }
        if (serverConfig.isCheatModeEnabledForCreative()) {
            allowedCheatingMethods.add("jei.chat.error.no.cheat.permission.creative");
        }
        if (serverConfig.isCheatModeEnabledForGive()) {
            allowedCheatingMethods.add("jei.chat.error.no.cheat.permission.give");
        }
        return allowedCheatingMethods;
    }
}

