/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.vanilla.ingredients.subtypes;

import java.util.ArrayList;
import java.util.StringJoiner;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.common.platform.IPlatformRegistry;
import mezz.jei.common.platform.Services;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;

public class EnchantedBookSubtypeInterpreter
implements IIngredientSubtypeInterpreter<ItemStack> {
    public static final EnchantedBookSubtypeInterpreter INSTANCE = new EnchantedBookSubtypeInterpreter();

    private EnchantedBookSubtypeInterpreter() {
    }

    public String apply(ItemStack itemStack, UidContext context) {
        ArrayList strings = new ArrayList();
        ListTag enchantments = EnchantedBookItem.getEnchantments((ItemStack)itemStack);
        for (int i = 0; i < enchantments.size(); ++i) {
            CompoundTag compoundnbt = enchantments.getCompound(i);
            String string = compoundnbt.getString("id");
            IPlatformRegistry enchantmentRegistry = Services.PLATFORM.getRegistry(Registries.ENCHANTMENT);
            ResourceLocation resourceLocation = ResourceLocation.tryParse((String)string);
            if (resourceLocation == null) continue;
            enchantmentRegistry.getValue(resourceLocation).map(enchantment -> enchantment.getDescriptionId() + ".lvl" + compoundnbt.getShort("lvl")).ifPresent(strings::add);
        }
        StringJoiner joiner = new StringJoiner(",", "[", "]");
        strings.sort(null);
        for (String string : strings) {
            joiner.add(string);
        }
        return joiner.toString();
    }
}

