/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.ingredients.itemStacks;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.time.Duration;
import java.util.Optional;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.library.ingredients.itemStacks.FullTypedItemStack;
import mezz.jei.library.ingredients.itemStacks.NormalizedTypedItemStack;
import net.minecraft.core.Holder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public abstract class TypedItemStack
implements ITypedIngredient<ItemStack> {
    private static final LoadingCache<TypedItemStack, ItemStack> CACHE = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofSeconds(1L)).build((CacheLoader)new CacheLoader<TypedItemStack, ItemStack>(){

        public ItemStack load(TypedItemStack key) {
            return key.createItemStackUncached();
        }
    });

    public static ITypedIngredient<ItemStack> create(ItemStack ingredient) {
        if (ingredient.getCount() == 1) {
            return NormalizedTypedItemStack.create((Holder<Item>)ingredient.getItemHolder(), ingredient.getTag());
        }
        return new FullTypedItemStack((Holder<Item>)ingredient.getItemHolder(), ingredient.getTag(), ingredient.getCount());
    }

    public static ITypedIngredient<ItemStack> normalize(ITypedIngredient<ItemStack> typedIngredient) {
        if (typedIngredient instanceof TypedItemStack) {
            TypedItemStack typedItemStack = (TypedItemStack)typedIngredient;
            return typedItemStack.getNormalized();
        }
        ItemStack itemStack = (ItemStack)typedIngredient.getIngredient();
        return NormalizedTypedItemStack.create((Holder<Item>)itemStack.getItemHolder(), itemStack.getTag());
    }

    public final ItemStack getIngredient() {
        return (ItemStack)CACHE.getUnchecked((Object)this);
    }

    public final Optional<ItemStack> getItemStack() {
        return Optional.of(this.getIngredient());
    }

    public final IIngredientType<ItemStack> getType() {
        return VanillaTypes.ITEM_STACK;
    }

    protected abstract TypedItemStack getNormalized();

    protected abstract ItemStack createItemStackUncached();
}

