/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.render;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collection;
import java.util.List;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.rendering.BatchRenderElement;
import mezz.jei.common.platform.IPlatformRenderHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.library.render.batch.ItemStackBatchRendererCache;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.Nullable;

public class ItemStackRenderer
implements IIngredientRenderer<ItemStack> {
    private final ItemStackBatchRendererCache batchRenderer = new ItemStackBatchRendererCache();

    public void render(GuiGraphics guiGraphics, @Nullable ItemStack ingredient) {
        this.render(guiGraphics, ingredient, 0, 0);
    }

    public void render(GuiGraphics guiGraphics, @Nullable ItemStack ingredient, int posX, int posY) {
        if (ingredient != null) {
            RenderSystem.enableDepthTest();
            Minecraft minecraft = Minecraft.getInstance();
            Font font = this.getFontRenderer(minecraft, ingredient);
            guiGraphics.renderFakeItem(ingredient, posX, posY);
            guiGraphics.renderItemDecorations(font, ingredient, posX, posY);
            RenderSystem.disableBlend();
        }
    }

    public void renderBatch(GuiGraphics guiGraphics, List<BatchRenderElement<ItemStack>> batchRenderElements) {
        this.batchRenderer.renderBatch(guiGraphics, this, batchRenderElements);
    }

    public List<Component> getTooltip(ItemStack ingredient, TooltipFlag tooltipFlag) {
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        return ingredient.getTooltipLines((Player)player, tooltipFlag);
    }

    public void getTooltip(ITooltipBuilder tooltip, ItemStack ingredient, TooltipFlag tooltipFlag) {
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        List components = ingredient.getTooltipLines((Player)player, tooltipFlag);
        tooltip.addAll((Collection)components);
    }

    public Font getFontRenderer(Minecraft minecraft, ItemStack ingredient) {
        IPlatformRenderHelper renderHelper = Services.PLATFORM.getRenderHelper();
        return renderHelper.getFontRenderer(minecraft, ingredient);
    }

    public int getWidth() {
        return 16;
    }

    public int getHeight() {
        return 16;
    }
}

